/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner;

import io.debezium.connector.spanner.FinishingPartitionManager;
import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.function.BlockingConsumer;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class FinishingPartitionManagerTest {
    FinishingPartitionManagerTest() {
    }

    @Test
    void commitRecord() throws InterruptedException {
        BlockingConsumer consumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
        SpannerConnectorConfig config = (SpannerConnectorConfig)Mockito.mock(SpannerConnectorConfig.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(config, consumer);
        finishingPartitionManager.registerPartition("testToken");
        finishingPartitionManager.newRecord("testToken");
        finishingPartitionManager.onPartitionFinishEvent("testToken");
        finishingPartitionManager.commitRecord("testToken", "aaaaaaaa");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept((Object)"testToken");
    }

    @Test
    void onPartitionFinishEvent() throws InterruptedException {
        BlockingConsumer consumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
        SpannerConnectorConfig config = (SpannerConnectorConfig)Mockito.mock(SpannerConnectorConfig.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(config, consumer);
        finishingPartitionManager.registerPartition("testToken");
        finishingPartitionManager.newRecord("testToken");
        finishingPartitionManager.commitRecord("testToken", "aaaaaaaa");
        finishingPartitionManager.onPartitionFinishEvent("testToken");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept((Object)"testToken");
    }

    @Test
    void forceFinish() throws InterruptedException {
        BlockingConsumer consumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
        SpannerConnectorConfig config = (SpannerConnectorConfig)Mockito.mock(SpannerConnectorConfig.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(config, consumer);
        finishingPartitionManager.registerPartition("testToken");
        finishingPartitionManager.newRecord("testToken");
        finishingPartitionManager.forceFinish("testToken");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept((Object)"testToken");
    }

    @Test
    void withoutRegistration() throws InterruptedException {
        BlockingConsumer consumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
        SpannerConnectorConfig config = (SpannerConnectorConfig)Mockito.mock(SpannerConnectorConfig.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(config, consumer);
        finishingPartitionManager.newRecord("testToken");
        finishingPartitionManager.commitRecord("testToken", "aaaaaaaa");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)0))).accept((Object)"testToken");
        finishingPartitionManager.onPartitionFinishEvent("testToken");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)0))).accept((Object)"testToken");
    }

    @Test
    void multipleCommitFinishEventFirst() throws InterruptedException {
        BlockingConsumer consumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
        SpannerConnectorConfig config = (SpannerConnectorConfig)Mockito.mock(SpannerConnectorConfig.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(config, consumer);
        finishingPartitionManager.registerPartition("testToken");
        finishingPartitionManager.newRecord("testToken");
        finishingPartitionManager.newRecord("testToken");
        finishingPartitionManager.newRecord("testToken");
        finishingPartitionManager.commitRecord("testToken", "aaaaaaaa");
        finishingPartitionManager.commitRecord("testToken", "aaaaaaab");
        finishingPartitionManager.onPartitionFinishEvent("testToken");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)0))).accept((Object)"testToken");
        finishingPartitionManager.commitRecord("testToken", "aaaaaaac");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept((Object)"testToken");
    }

    @Test
    void multipleCommitCommitFirst1() throws InterruptedException {
        BlockingConsumer consumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
        SpannerConnectorConfig config = (SpannerConnectorConfig)Mockito.mock(SpannerConnectorConfig.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(config, consumer);
        finishingPartitionManager.registerPartition("testToken");
        finishingPartitionManager.newRecord("testToken");
        finishingPartitionManager.newRecord("testToken");
        finishingPartitionManager.newRecord("testToken");
        finishingPartitionManager.commitRecord("testToken", "aaaaaaaa");
        finishingPartitionManager.commitRecord("testToken", "aaaaaaab");
        finishingPartitionManager.commitRecord("testToken", "aaaaaaac");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)0))).accept((Object)"testToken");
        finishingPartitionManager.onPartitionFinishEvent("testToken");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept((Object)"testToken");
    }

    @Test
    void multipleCommitCommitFirst2() throws InterruptedException {
        BlockingConsumer consumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
        SpannerConnectorConfig config = (SpannerConnectorConfig)Mockito.mock(SpannerConnectorConfig.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(config, consumer);
        finishingPartitionManager.registerPartition("testToken");
        finishingPartitionManager.newRecord("testToken");
        finishingPartitionManager.newRecord("testToken");
        finishingPartitionManager.commitRecord("testToken", "aaaaaaaa");
        finishingPartitionManager.commitRecord("testToken", "aaaaaaab");
        finishingPartitionManager.newRecord("testToken");
        finishingPartitionManager.commitRecord("testToken", "aaaaaaac");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)0))).accept((Object)"testToken");
        finishingPartitionManager.onPartitionFinishEvent("testToken");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept((Object)"testToken");
    }

    @Test
    void multipleCommitCommitOutOfOrder() throws InterruptedException {
        BlockingConsumer consumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
        SpannerConnectorConfig config = (SpannerConnectorConfig)Mockito.mock(SpannerConnectorConfig.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(config, consumer);
        finishingPartitionManager.registerPartition("testToken");
        finishingPartitionManager.newRecord("testToken");
        finishingPartitionManager.newRecord("testToken");
        finishingPartitionManager.newRecord("testToken");
        finishingPartitionManager.commitRecord("testToken", "aaaaaaaa");
        finishingPartitionManager.commitRecord("testToken", "aaaaaaac");
        finishingPartitionManager.commitRecord("testToken", "aaaaaaab");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)0))).accept((Object)"testToken");
        finishingPartitionManager.onPartitionFinishEvent("testToken");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept((Object)"testToken");
    }

    @Test
    void multipleCommitNoEvents() throws InterruptedException {
        BlockingConsumer consumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
        SpannerConnectorConfig config = (SpannerConnectorConfig)Mockito.mock(SpannerConnectorConfig.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(config, consumer);
        finishingPartitionManager.registerPartition("testToken");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)0))).accept((Object)"testToken");
        finishingPartitionManager.onPartitionFinishEvent("testToken");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept((Object)"testToken");
    }

    @Test
    void multipleCommitNoEventsWithWrongCommitCall() throws InterruptedException {
        BlockingConsumer consumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
        SpannerConnectorConfig config = (SpannerConnectorConfig)Mockito.mock(SpannerConnectorConfig.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(config, consumer);
        finishingPartitionManager.registerPartition("testToken");
        finishingPartitionManager.commitRecord("testToken", "recordUid3");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)0))).accept((Object)"testToken");
        finishingPartitionManager.onPartitionFinishEvent("testToken");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept((Object)"testToken");
    }

    @Test
    void multipleCommitNoEventsWithWrongCommitCallOnly() throws InterruptedException {
        BlockingConsumer consumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
        SpannerConnectorConfig config = (SpannerConnectorConfig)Mockito.mock(SpannerConnectorConfig.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(config, consumer);
        finishingPartitionManager.registerPartition("testToken");
        finishingPartitionManager.commitRecord("testToken", "recordUid3");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)0))).accept((Object)"testToken");
    }
}

