/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db.dao;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import io.debezium.connector.spanner.db.model.schema.ChangeStreamSchema;
import io.debezium.connector.spanner.db.model.schema.SpannerSchema;
import java.util.Collection;
import java.util.stream.Collectors;

public class SchemaDao {
    private final DatabaseClient databaseClient;

    public SchemaDao(DatabaseClient databaseClient) {
        this.databaseClient = databaseClient;
    }

    public SpannerSchema getSchema(Timestamp timestamp) {
        return this.getSchema(timestamp, null);
    }

    public SpannerSchema getSchema(Timestamp timestamp, Collection<String> tables) {
        SpannerSchema.SpannerSchemaBuilder builder = SpannerSchema.builder();
        try (ReadOnlyTransaction tx = this.databaseClient.readOnlyTransaction(TimestampBound.ofReadTimestamp((Timestamp)timestamp));){
            String columnName;
            String tableName;
            ResultSet resultSet = this.readColumnsInfo(tx, tables);
            ResultSet primaryColumnsResultSet = this.readPrimaryColumns(tx, tables);
            while (primaryColumnsResultSet.next()) {
                tableName = primaryColumnsResultSet.getString(0);
                columnName = primaryColumnsResultSet.getString(1);
                builder.addPrimaryColumn(tableName, columnName);
            }
            while (resultSet.next()) {
                tableName = resultSet.getString(0);
                columnName = resultSet.getString(1);
                String type = resultSet.getString(2);
                long ordinalPosition = resultSet.getLong(3);
                boolean nullable = resultSet.getBoolean(4);
                builder.addColumn(tableName, columnName, type, ordinalPosition, nullable, this.databaseClient.getDialect());
            }
        }
        return builder.build();
    }

    public ChangeStreamSchema getStream(Timestamp timestamp, String streamName) {
        ChangeStreamSchema.Builder builder = ChangeStreamSchema.builder().name(streamName);
        boolean exist = false;
        try (ReadOnlyTransaction tx = this.databaseClient.readOnlyTransaction(TimestampBound.ofReadTimestamp((Timestamp)timestamp));){
            ResultSet resultSet = this.readChangeStreamInfo(tx, streamName);
            while (resultSet.next()) {
                exist = true;
                boolean allTables = resultSet.getBoolean(0);
                builder.allTables(allTables);
                if (allTables) continue;
                String tableName = resultSet.getString(1);
                boolean allColumns = resultSet.getBoolean(2);
                builder.table(tableName, allColumns);
                if (allColumns) continue;
                String columnName = resultSet.getString(3);
                builder.column(tableName, columnName);
            }
        }
        return exist ? builder.build() : null;
    }

    private ResultSet readColumnsInfo(ReadOnlyTransaction tx, Collection<String> tables) {
        Statement statement = this.isPostgres() ? Statement.newBuilder((String)("SELECT  table_name,  column_name,  spanner_type,  ordinal_position,  CASE WHEN is_nullable = 'YES' THEN TRUE ELSE FALSE END AS is_nullable\nFROM  information_schema.COLUMNS \nWHERE  table_schema = 'public'" + (String)(tables == null ? "" : " AND table_name = ANY(Array[" + tables.stream().map(s -> "'" + s + "'").collect(Collectors.joining(",")) + "])"))).build() : ((Statement.Builder)Statement.newBuilder((String)("SELECT  table_name,  column_name,  spanner_type,  ordinal_position,  IF(is_nullable = 'YES', true, false) AS is_nullable\nFROM  information_schema.COLUMNS \nWHERE  table_catalog = ''  AND table_schema = ''" + (tables == null ? "" : "  AND table_name in UNNEST(@tables)"))).bind("tables").toStringArray(tables)).build();
        return tx.executeQuery(statement, new Options.QueryOption[0]);
    }

    private ResultSet readPrimaryColumns(ReadOnlyTransaction tx, Collection<String> tables) {
        Statement statement = this.isPostgres() ? Statement.newBuilder((String)("SELECT  table_name,  column_name\nFROM  information_schema.index_columns \nWHERE   index_name = 'PRIMARY_KEY'" + (String)(tables == null ? "" : "  AND table_name = ANY(Array[" + tables.stream().map(s -> "'" + s + "'").collect(Collectors.joining(",")) + "])"))).build() : ((Statement.Builder)Statement.newBuilder((String)("SELECT  table_name,  column_name\nFROM  information_schema.index_columns \nWHERE   index_name = 'PRIMARY_KEY'" + (tables == null ? "" : "  AND table_name in UNNEST(@tables)"))).bind("tables").toStringArray(tables)).build();
        return tx.executeQuery(statement, new Options.QueryOption[0]);
    }

    private ResultSet readChangeStreamInfo(ReadOnlyTransaction tx, String streamName) {
        Statement statement = this.isPostgres() ? ((Statement.Builder)Statement.newBuilder((String)"select  CASE WHEN cs.all = 'YES' then true else false end AS all,  cst.table_name,  CASE WHEN cst.all_columns = 'YES' then true else false end AS all_columns,  csc.column_name\nfrom  information_schema.change_streams cs\nleft join  information_schema.change_stream_tables cst\non  cst.change_stream_name = cs.change_stream_name\nleft join  information_schema.change_stream_columns csc\non  csc.change_stream_name = cs.change_stream_name\n  and csc.table_name = cst.table_name\nwhere cs.change_stream_name = $1").bind("p1").to(streamName)).build() : ((Statement.Builder)Statement.newBuilder((String)"select  cs.all,  cst.table_name,  cst.all_columns,  csc.column_name\nfrom  information_schema.change_streams cs\nleft join  information_schema.change_stream_tables cst\non  cst.change_stream_name = cs.change_stream_name\nleft join  information_schema.change_stream_columns csc\non  csc.change_stream_name = cs.change_stream_name\n  and csc.table_name = cst.table_name\nwhere cs.change_stream_name = @streamName").bind("streamName").to(streamName)).build();
        return tx.executeQuery(statement, new Options.QueryOption[0]);
    }

    private boolean isPostgres() {
        return this.databaseClient.getDialect() == Dialect.POSTGRESQL;
    }
}

