/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.kafka.internal;

import com.google.protobuf.InvalidProtocolBufferException;
import io.debezium.connector.spanner.exception.SpannerConnectorException;
import io.debezium.connector.spanner.function.BlockingBiConsumer;
import io.debezium.connector.spanner.kafka.event.proto.SyncEventProtos;
import io.debezium.connector.spanner.kafka.internal.SyncEventConsumerFactory;
import io.debezium.connector.spanner.kafka.internal.model.SyncEventMetadata;
import io.debezium.connector.spanner.kafka.internal.model.TaskSyncEvent;
import io.debezium.connector.spanner.kafka.internal.proto.SyncEventFromProtoMapper;
import io.debezium.connector.spanner.task.LoggerUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InterruptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskSyncEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskSyncEventListener.class);
    private final String consumerGroup;
    private final String topic;
    private final boolean seekBackToPreviousEpoch;
    private final Duration pollDuration;
    private final Duration commitOffsetsTimeout;
    private final long commitOffsetsInterval;
    private final SyncEventConsumerFactory<String, byte[]> consumerFactory;
    private final List<BlockingBiConsumer<TaskSyncEvent, SyncEventMetadata>> eventConsumers = new ArrayList<BlockingBiConsumer<TaskSyncEvent, SyncEventMetadata>>();
    private final java.util.function.Consumer<RuntimeException> errorHandler;
    private volatile Thread thread;

    public TaskSyncEventListener(String consumerGroup, String topic, SyncEventConsumerFactory<String, byte[]> consumerFactory, boolean seekBackToPreviousEpoch, java.util.function.Consumer<RuntimeException> errorHandler) {
        this.consumerGroup = consumerGroup;
        this.topic = topic;
        this.seekBackToPreviousEpoch = seekBackToPreviousEpoch;
        this.pollDuration = Duration.ofMillis(consumerFactory.getConfig().syncPollDuration());
        this.commitOffsetsTimeout = Duration.ofMillis(consumerFactory.getConfig().syncCommitOffsetsTimeout());
        this.commitOffsetsInterval = consumerFactory.getConfig().syncCommitOffsetsInterval();
        this.consumerFactory = consumerFactory;
        this.errorHandler = errorHandler;
    }

    public void subscribe(BlockingBiConsumer<TaskSyncEvent, SyncEventMetadata> eventConsumer) {
        this.eventConsumers.add(eventConsumer);
    }

    public void unsubscribe(BiConsumer<TaskSyncEvent, SyncEventMetadata> eventConsumer) {
        this.eventConsumers.remove(eventConsumer);
    }

    public void start() throws InterruptedException {
        Long endOffset;
        Consumer<String, byte[]> consumer;
        block7: {
            TopicPartition topicPartition = new TopicPartition(this.topic, 0);
            List<TopicPartition> assignment = List.of(topicPartition);
            consumer = this.consumerFactory.createConsumer(this.consumerGroup);
            consumer.assign(assignment);
            endOffset = (Long)consumer.endOffsets(assignment).get(topicPartition);
            Long beginOffset = (Long)consumer.beginningOffsets(assignment).get(topicPartition);
            long startOffset = Math.max(endOffset - 1L, beginOffset);
            try {
                if (endOffset == startOffset) {
                    LOGGER.debug("listen: Sync topic is empty, so initial sync is finished");
                    for (BlockingBiConsumer<TaskSyncEvent, SyncEventMetadata> eventConsumer : this.eventConsumers) {
                        eventConsumer.accept(null, SyncEventMetadata.builder().canInitiateRebalancing(true).build());
                    }
                    break block7;
                }
                LOGGER.debug("listen: read last message");
                try {
                    consumer.seek(topicPartition, startOffset);
                    this.seekBackToPreviousEpoch(consumer, topicPartition, beginOffset);
                }
                catch (InterruptException e) {
                    throw new InterruptedException();
                }
                catch (Exception e) {
                    this.errorHandler.accept(new SpannerConnectorException("Error during seek back the Sync Topic", e));
                    return;
                }
            }
            catch (Exception ex) {
                this.shutdownConsumer(consumer);
                throw ex;
            }
        }
        this.thread = new Thread(() -> {
            try {
                long commitOffsetStart = System.currentTimeMillis();
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        this.poll(consumer, endOffset);
                        if (this.consumerFactory.isAutoCommitEnabled() || commitOffsetStart + this.commitOffsetsInterval >= System.currentTimeMillis()) continue;
                        consumer.commitSync(this.commitOffsetsTimeout);
                        commitOffsetStart = System.currentTimeMillis();
                    }
                    catch (InterruptedException | InterruptException ex) {
                        this.shutdownConsumer(consumer);
                        return;
                    }
                    catch (Exception e) {
                        try {
                            this.errorHandler.accept(new SpannerConnectorException("Error during poll from the Sync Topic", e));
                            this.shutdownConsumer(consumer);
                            return;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            return;
                        }
                    }
                }
            }
            finally {
                this.shutdownConsumer(consumer);
            }
        }, "SpannerConnector-TaskSyncEventListener");
        this.thread.start();
    }

    private int poll(Consumer<String, byte[]> consumer, long endOffset) throws InvalidProtocolBufferException, InterruptedException {
        ConsumerRecords records = consumer.poll(this.pollDuration);
        LOGGER.trace("listen: poll messages count: {}", (Object)records.count());
        if (records.isEmpty()) {
            return 0;
        }
        for (ConsumerRecord record : records) {
            TaskSyncEvent taskSyncEvent = this.parseSyncEvent((ConsumerRecord<String, byte[]>)record);
            LoggerUtils.debug(LOGGER, "Receive SyncEvent from Kafka topic: {}", taskSyncEvent);
            for (BlockingBiConsumer<TaskSyncEvent, SyncEventMetadata> eventConsumer : this.eventConsumers) {
                eventConsumer.accept(taskSyncEvent, SyncEventMetadata.builder().offset(record.offset()).canInitiateRebalancing(record.offset() >= endOffset - 1L).build());
            }
        }
        return records.count();
    }

    private void seekBackToPreviousEpoch(Consumer<String, byte[]> consumer, TopicPartition topicPartition, long beginOffset) throws InvalidProtocolBufferException {
        if (!this.seekBackToPreviousEpoch) {
            return;
        }
        ConsumerRecords records = consumer.poll(this.pollDuration);
        if (records.isEmpty()) {
            LOGGER.warn("listen: fail to poll last message");
            return;
        }
        ConsumerRecord lastRecord = (ConsumerRecord)records.iterator().next();
        TaskSyncEvent taskSyncEvent = this.parseSyncEvent((ConsumerRecord<String, byte[]>)lastRecord);
        long previousEpochOffset = taskSyncEvent.getEpochOffset();
        long startOffset = Math.max(previousEpochOffset, beginOffset);
        LOGGER.debug("listen: seek back to previous epoch offset: {}", (Object)startOffset);
        consumer.seek(topicPartition, startOffset);
    }

    private TaskSyncEvent parseSyncEvent(ConsumerRecord<String, byte[]> record) throws InvalidProtocolBufferException {
        return SyncEventFromProtoMapper.mapFromProto(SyncEventProtos.SyncEvent.parseFrom((byte[])record.value()));
    }

    private void shutdownConsumer(Consumer<String, byte[]> consumer) {
        block2: {
            try {
                consumer.unsubscribe();
                consumer.close();
            }
            catch (InterruptException e) {
                if (Thread.currentThread().isInterrupted()) break block2;
                Thread.currentThread().interrupt();
            }
        }
    }

    public void shutdown() {
        if (this.thread == null) {
            return;
        }
        this.thread.interrupt();
        while (!this.thread.getState().equals((Object)Thread.State.TERMINATED)) {
        }
        this.thread = null;
    }
}

