/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;

public class LoggerUtils {
    private static final LoggerUtils INSTANCE = new LoggerUtils();
    private final AtomicBoolean isJsonLogEnabled = new AtomicBoolean(false);
    private final ObjectWriter objectWriter = new ObjectMapper().disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).writerWithDefaultPrettyPrinter();

    private LoggerUtils() {
    }

    private void setJsonLogEnabled(boolean isJsonLogEnabled) {
        this.isJsonLogEnabled.set(isJsonLogEnabled);
    }

    public static void enableJsonLog() {
        INSTANCE.setJsonLogEnabled(true);
    }

    public static void debug(Logger logger, String message, Object ... objects) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        if (INSTANCE.isJsonLogEnabled()) {
            Object[] strings = (String[])Arrays.stream(objects).map(o -> LoggerUtils.isNotObject(o) ? LoggerUtils.toString(o) : LoggerUtils.toPrettyJson(o)).toArray(String[]::new);
            logger.debug(message, strings);
        } else {
            logger.debug(message, objects);
        }
    }

    private boolean isJsonLogEnabled() {
        return this.isJsonLogEnabled.get();
    }

    private ObjectWriter getObjectWriter() {
        return this.objectWriter;
    }

    private static String toPrettyJson(Object object) {
        try {
            return INSTANCE.getObjectWriter().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String toString(Object object) {
        return object == null ? "null" : object.toString();
    }

    private static boolean isNotObject(Object object) {
        return object == null || ClassUtils.isPrimitiveOrWrapper(object.getClass()) || object instanceof String;
    }
}

