/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.config.validation;

import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Statement;
import com.google.common.annotations.VisibleForTesting;
import io.debezium.connector.spanner.config.BaseSpannerConnectorConfig;
import io.debezium.connector.spanner.config.validation.ConfigurationValidator;
import io.debezium.connector.spanner.db.DatabaseClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeStreamValidator
implements ConfigurationValidator.Validator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeStreamValidator.class);
    private final ConfigurationValidator.ValidationContext context;
    private boolean result;

    private ChangeStreamValidator(ConfigurationValidator.ValidationContext context) {
        this.context = context;
    }

    public static ChangeStreamValidator withContext(ConfigurationValidator.ValidationContext validationContext) {
        return new ChangeStreamValidator(validationContext);
    }

    @Override
    public boolean isSuccess() {
        return this.result;
    }

    @Override
    public ChangeStreamValidator validate() {
        String changeStreamName = this.context.getString(BaseSpannerConnectorConfig.CHANGE_STREAM_NAME);
        DatabaseClientFactory databaseClientFactory = new DatabaseClientFactory(this.context.getString(BaseSpannerConnectorConfig.PROJECT_ID), this.context.getString(BaseSpannerConnectorConfig.INSTANCE_ID), this.context.getString(BaseSpannerConnectorConfig.DATABASE_ID), this.context.getString(BaseSpannerConnectorConfig.SPANNER_CREDENTIALS_JSON), this.context.getString(BaseSpannerConnectorConfig.SPANNER_CREDENTIALS_PATH), this.context.getString(BaseSpannerConnectorConfig.SPANNER_HOST), this.context.getString(BaseSpannerConnectorConfig.DATABASE_ROLE));
        this.result = this.isStreamExist(databaseClientFactory.getDatabaseClient(), changeStreamName);
        if (!this.result) {
            String msg = "ChangeStream '" + changeStreamName + "' doesn't exist";
            LOGGER.error(msg);
            this.context.error(msg, BaseSpannerConnectorConfig.CHANGE_STREAM_NAME);
        }
        return this;
    }

    @VisibleForTesting
    boolean isStreamExist(DatabaseClient databaseClient, String streamName) {
        Statement statement = databaseClient.getDialect() == Dialect.POSTGRESQL ? ((Statement.Builder)Statement.newBuilder((String)"select change_stream_name from information_schema.change_streams cs where cs.change_stream_name = $1").bind("p1").to(streamName.toLowerCase())).build() : ((Statement.Builder)Statement.newBuilder((String)"select change_stream_name from information_schema.change_streams cs where cs.change_stream_name = @streamname").bind("streamName").to(streamName)).build();
        return databaseClient.singleUse().executeQuery(statement, new Options.QueryOption[0]).next();
    }
}

