/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db.dao;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import io.debezium.connector.spanner.db.model.schema.ChangeStreamSchema;
import io.debezium.connector.spanner.db.model.schema.SpannerSchema;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;

public class SchemaDao {
    private final DatabaseClient databaseClient;

    public SchemaDao(DatabaseClient databaseClient) {
        this.databaseClient = databaseClient;
    }

    public SpannerSchema getSchema(Timestamp timestamp) {
        return this.getSchema(timestamp, null);
    }

    public SpannerSchema getSchema(Timestamp timestamp, Collection<String> tables) {
        SpannerSchema.SpannerSchemaBuilder builder = SpannerSchema.builder();
        try (ReadOnlyTransaction tx = this.databaseClient.readOnlyTransaction(TimestampBound.ofReadTimestamp((Timestamp)timestamp));){
            ResultSet resultSet = this.readTablesInfo(tx, tables);
            while (resultSet.next()) {
                String tableName = resultSet.getString(0);
                String columnName = resultSet.getString(1);
                String type = resultSet.getString(2);
                long ordinalPosition = resultSet.getLong(3);
                boolean primaryKey = resultSet.getBoolean(4);
                boolean nullable = resultSet.getBoolean(5);
                builder.addColumn(tableName, columnName, type, ordinalPosition, primaryKey, nullable, this.databaseClient.getDialect());
            }
        }
        return builder.build();
    }

    private boolean isTrue(ResultSet resultSet, int index) {
        if (this.isPostgres()) {
            return Objects.equals(resultSet.getString(index), "YES");
        }
        return resultSet.getBoolean(index);
    }

    public ChangeStreamSchema getStream(Timestamp timestamp, String streamName) {
        ChangeStreamSchema.Builder builder = ChangeStreamSchema.builder().name(streamName);
        boolean exist = false;
        try (ReadOnlyTransaction tx = this.databaseClient.readOnlyTransaction(TimestampBound.ofReadTimestamp((Timestamp)timestamp));){
            ResultSet resultSet = this.readChangeStreamInfo(tx, streamName);
            while (resultSet.next()) {
                exist = true;
                boolean allTables = this.isTrue(resultSet, 0);
                builder.allTables(allTables);
                if (allTables) continue;
                String tableName = resultSet.getString(1);
                boolean allColumns = this.isTrue(resultSet, 2);
                builder.table(tableName, allColumns);
                if (allColumns) continue;
                String columnName = resultSet.getString(3);
                builder.column(tableName, columnName);
            }
        }
        return exist ? builder.build() : null;
    }

    private ResultSet readTablesInfo(ReadOnlyTransaction tx, Collection<String> tables) {
        Statement statement = this.isPostgres() ? Statement.newBuilder((String)("SELECT  s.table_name,  s.column_name,  s.spanner_type,  s.ordinal_position,CASE WHEN inx.index_name = 'PRIMARY_KEY' THEN TRUE ELSE FALSE END AS primary_key,\nCASE WHEN s.is_nullable = 'YES' THEN TRUE ELSE FALSE END AS is_nullable\nFROM\n  information_schema.COLUMNS AS s\nLEFT JOIN\n  information_schema.index_columns inx\nON\n  s.table_name = inx.table_name\n  AND s.column_name = inx.column_name\nWHERE\n  s.table_schema = 'public'\n" + (String)(tables == null ? "" : " AND s.table_name = ANY(Array[" + tables.stream().map(s -> "'" + s + "'").collect(Collectors.joining(",")) + "])"))).build() : ((Statement.Builder)Statement.newBuilder((String)("SELECT  s.table_name,  s.column_name,  s.spanner_type,  s.ordinal_position,  IF(inx.index_name = 'PRIMARY_KEY', true, false) AS primary_key,  IF(s.is_nullable = 'YES', true, false) AS is_nullable\nFROM  information_schema.COLUMNS AS s\nLEFT JOIN information_schema.index_columns inx on s.table_name = inx.table_name and s.column_name = inx.column_name\nWHERE  s.table_catalog = ''  AND s.table_schema = ''" + (tables == null ? "" : "  AND s.table_name in UNNEST(@tables)"))).bind("tables").toStringArray(tables)).build();
        return tx.executeQuery(statement, new Options.QueryOption[0]);
    }

    private ResultSet readChangeStreamInfo(ReadOnlyTransaction tx, String streamName) {
        Statement statement = this.isPostgres() ? ((Statement.Builder)Statement.newBuilder((String)"select  cs.all,  cst.table_name,  cst.all_columns,  csc.column_name\nfrom  information_schema.change_streams cs\nleft join  information_schema.change_stream_tables cst\non  cst.change_stream_name = cs.change_stream_name\nleft join  information_schema.change_stream_columns csc\non  csc.change_stream_name = cs.change_stream_name\n  and csc.table_name = cst.table_name\nwhere cs.change_stream_name = $1").bind("p1").to(streamName)).build() : ((Statement.Builder)Statement.newBuilder((String)"select  cs.all,  cst.table_name,  cst.all_columns,  csc.column_name\nfrom  information_schema.change_streams cs\nleft join  information_schema.change_stream_tables cst\non  cst.change_stream_name = cs.change_stream_name\nleft join  information_schema.change_stream_columns csc\non  csc.change_stream_name = cs.change_stream_name\n  and csc.table_name = cst.table_name\nwhere cs.change_stream_name = @streamName").bind("streamName").to(streamName)).build();
        return tx.executeQuery(statement, new Options.QueryOption[0]);
    }

    private boolean isPostgres() {
        return this.databaseClient.getDialect() == Dialect.POSTGRESQL;
    }
}

