/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.kafka.internal;

import io.debezium.connector.spanner.exception.SpannerConnectorException;
import io.debezium.connector.spanner.kafka.event.proto.SyncEventProtos;
import io.debezium.connector.spanner.kafka.internal.BufferedPublisher;
import io.debezium.connector.spanner.kafka.internal.ProducerFactory;
import io.debezium.connector.spanner.kafka.internal.model.MessageTypeEnum;
import io.debezium.connector.spanner.kafka.internal.model.TaskSyncEvent;
import io.debezium.connector.spanner.kafka.internal.proto.SyncEventToProtoMapper;
import io.debezium.connector.spanner.task.LoggerUtils;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskSyncPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskSyncPublisher.class);
    private final String topic;
    private final KafkaProducer<String, byte[]> producer;
    private volatile Instant lastTime;
    private final BufferedPublisher<TaskSyncEvent> bufferedPublisher;
    private final Consumer<RuntimeException> errorHandler;
    private final String taskUid;

    public TaskSyncPublisher(String taskUid, String topic, int syncEventPublisherWaitingTimeout, ProducerFactory<String, byte[]> producerFactory, Consumer<RuntimeException> errorHandler) {
        this.topic = topic;
        this.producer = producerFactory.createProducer();
        this.errorHandler = errorHandler;
        this.taskUid = taskUid;
        if (syncEventPublisherWaitingTimeout > 0) {
            this.bufferedPublisher = new BufferedPublisher<TaskSyncEvent>(this.taskUid, "Buffer-Pub", syncEventPublisherWaitingTimeout, this::publishImmediately, this::publishSyncEvent);
            this.bufferedPublisher.start();
        } else {
            this.bufferedPublisher = null;
        }
    }

    public void send(TaskSyncEvent taskSyncEvent) {
        if (this.bufferedPublisher == null) {
            this.publishSyncEvent(taskSyncEvent);
        } else {
            LOGGER.debug("Buffering Sync Event, type: {}, timestamp: {}", (Object)taskSyncEvent.getMessageType(), (Object)taskSyncEvent.getMessageTimestamp());
            this.bufferedPublisher.buffer(taskSyncEvent);
        }
    }

    private void publishSyncEvent(TaskSyncEvent taskSyncEvent) {
        LoggerUtils.debug(LOGGER, "Send SyncEvent to Kafka topic, type: {}, timestamp: {}, event: {}", new Object[]{taskSyncEvent.getMessageType(), taskSyncEvent.getMessageTimestamp(), taskSyncEvent});
        SyncEventProtos.SyncEvent protoEvent = SyncEventToProtoMapper.mapToProto(taskSyncEvent);
        ProducerRecord record = new ProducerRecord(this.topic, (Object)taskSyncEvent.getTaskUid(), (Object)protoEvent.toByteArray());
        try {
            Instant sendTime = Instant.now();
            this.producer.send(record).get();
            this.producer.flush();
            if (Instant.now().isAfter(sendTime.plus(Duration.ofSeconds(60L)))) {
                long seconds = Instant.now().getEpochSecond() - sendTime.getEpochSecond();
                LOGGER.info("Task Uid {} published record {} with {} seconds latency", new Object[]{this.taskUid, record, seconds});
            }
            this.lastTime = Instant.now();
        }
        catch (ExecutionException e) {
            this.close();
            this.errorHandler.accept(new SpannerConnectorException("Error during publishing to the Sync Topic", e));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void close() {
        if (this.bufferedPublisher != null) {
            this.bufferedPublisher.close();
        }
        this.producer.close();
    }

    public Instant getLastTime() {
        return this.lastTime;
    }

    private boolean publishImmediately(TaskSyncEvent syncEvent) {
        return syncEvent.getMessageType() != null && syncEvent.getMessageType() != MessageTypeEnum.REGULAR;
    }
}

