/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db.dao;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import io.debezium.connector.spanner.db.dao.ChangeStreamResultSet;
import io.debezium.connector.spanner.db.model.InitialPartition;

public class ChangeStreamDao {
    private final String changeStreamName;
    private final DatabaseClient databaseClient;
    private final Options.RpcPriority rpcPriority;
    private final String jobName;

    public ChangeStreamDao(String changeStreamName, DatabaseClient databaseClient, Options.RpcPriority rpcPriority, String jobName) {
        this.changeStreamName = changeStreamName;
        this.databaseClient = databaseClient;
        this.rpcPriority = rpcPriority;
        this.jobName = jobName;
    }

    public ChangeStreamResultSet streamQuery(String partitionToken, Timestamp startTimestamp, Timestamp endTimestamp, long heartbeatMillis) {
        String partitionTokenOrNull = InitialPartition.isInitialPartition(partitionToken) ? null : partitionToken;
        String query = "SELECT * FROM READ_" + this.changeStreamName + "(   start_timestamp => @startTimestamp,   end_timestamp => @endTimestamp,   partition_token => @partitionToken,   read_options => null,   heartbeat_milliseconds => @heartbeatMillis)";
        ResultSet resultSet = this.databaseClient.singleUse().executeQuery(((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)query).bind("startTimestamp").to(startTimestamp)).bind("endTimestamp").to(endTimestamp)).bind("partitionToken").to(partitionTokenOrNull)).bind("heartbeatMillis").to(heartbeatMillis)).build(), new Options.QueryOption[]{Options.priority((Options.RpcPriority)this.rpcPriority), Options.tag((String)("job=" + this.jobName))});
        return new ChangeStreamResultSet(resultSet);
    }
}

