/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.schema.mapper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.NullNode;
import io.debezium.connector.spanner.schema.mapper.JsonNodeStructValueConvertor;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.kafka.connect.data.Schema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class JsonNodeStructValueConvertorTest {
    JsonNodeStructValueConvertorTest() {
    }

    @Test
    void testGetBytesNotNull() {
        Assertions.assertNotNull((Object)JsonNodeStructValueConvertor.getBytes((JsonNode)MissingNode.getInstance()));
    }

    @Test
    void testGetBytes() {
        ByteBuffer bytes = JsonNodeStructValueConvertor.getBytes((JsonNode)new ObjectMapper().createObjectNode());
        Assertions.assertNotNull((Object)bytes);
    }

    @Test
    void testGetLong() {
        Assertions.assertEquals((long)0L, (long)JsonNodeStructValueConvertor.getLong((JsonNode)MissingNode.getInstance()));
        Assertions.assertEquals((long)42L, (long)JsonNodeStructValueConvertor.getLong((JsonNode)new BigIntegerNode(BigInteger.valueOf(42L))));
        Assertions.assertEquals((long)0L, (long)JsonNodeStructValueConvertor.getLong((JsonNode)BooleanNode.getFalse()));
        Assertions.assertNull((Object)JsonNodeStructValueConvertor.getLong((JsonNode)NullNode.getInstance()));
    }

    @Test
    void testGetDouble() {
        Assertions.assertEquals((double)0.0, (double)JsonNodeStructValueConvertor.getDouble((JsonNode)MissingNode.getInstance()));
        Assertions.assertEquals((double)42.0, (double)JsonNodeStructValueConvertor.getDouble((JsonNode)new BigIntegerNode(BigInteger.valueOf(42L))));
        Assertions.assertEquals((double)0.0, (double)JsonNodeStructValueConvertor.getDouble((JsonNode)BooleanNode.getFalse()));
        Assertions.assertNull((Object)JsonNodeStructValueConvertor.getDouble((JsonNode)NullNode.getInstance()));
    }

    @Test
    void testGetBoolean() {
        Assertions.assertFalse((boolean)JsonNodeStructValueConvertor.getBoolean((JsonNode)MissingNode.getInstance()));
        Assertions.assertTrue((boolean)JsonNodeStructValueConvertor.getBoolean((JsonNode)new BigIntegerNode(BigInteger.valueOf(42L))));
        Assertions.assertFalse((boolean)JsonNodeStructValueConvertor.getBoolean((JsonNode)BooleanNode.getFalse()));
        Assertions.assertNull((Object)JsonNodeStructValueConvertor.getBoolean((JsonNode)NullNode.getInstance()));
    }

    @Test
    void testGetString() throws UnsupportedEncodingException {
        Assertions.assertEquals((Object)"", (Object)JsonNodeStructValueConvertor.getString((JsonNode)MissingNode.getInstance()));
        Assertions.assertEquals((Object)"dGVzdA==", (Object)JsonNodeStructValueConvertor.getString((JsonNode)new BinaryNode("test".getBytes("UTF-8"))));
        Assertions.assertNull((Object)JsonNodeStructValueConvertor.getString((JsonNode)NullNode.getInstance()));
    }

    @Test
    void testGetList() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> JsonNodeStructValueConvertor.getList((JsonNode)MissingNode.getInstance(), (Schema.Type)Schema.Type.INT8));
        Assertions.assertTrue((boolean)JsonNodeStructValueConvertor.getList((JsonNode)new ArrayNode(JsonNodeFactory.withExactBigDecimals((boolean)true)), (Schema.Type)Schema.Type.INT8).isEmpty());
        Assertions.assertNull((Object)JsonNodeStructValueConvertor.getList((JsonNode)NullNode.getInstance(), (Schema.Type)Schema.Type.INT8));
        Assertions.assertThrows(IllegalArgumentException.class, () -> JsonNodeStructValueConvertor.getList((JsonNode)MissingNode.getInstance(), (Schema.Type)Schema.Type.INT16));
        Assertions.assertThrows(IllegalArgumentException.class, () -> JsonNodeStructValueConvertor.getList((JsonNode)MissingNode.getInstance(), (Schema.Type)Schema.Type.INT32));
        Assertions.assertThrows(IllegalArgumentException.class, () -> JsonNodeStructValueConvertor.getList((JsonNode)MissingNode.getInstance(), (Schema.Type)Schema.Type.INT64));
    }

    @Test
    void testGetListThrows() {
        ArrayNode arrayNode = new ArrayNode(JsonNodeFactory.withExactBigDecimals((boolean)true));
        arrayNode.add((JsonNode)MissingNode.getInstance());
        Assertions.assertThrows(IllegalArgumentException.class, () -> JsonNodeStructValueConvertor.getList((JsonNode)arrayNode, (Schema.Type)Schema.Type.INT8));
    }
}

