/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.processor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import io.debezium.connector.spanner.SpannerPartition;
import io.debezium.connector.spanner.context.offset.SpannerOffsetContext;
import io.debezium.connector.spanner.db.metadata.TableId;
import io.debezium.connector.spanner.db.model.Mod;
import io.debezium.connector.spanner.db.model.ModType;
import io.debezium.connector.spanner.processor.SpannerChangeRecordEmitter;
import io.debezium.connector.spanner.schema.KafkaSpannerTableSchema;
import io.debezium.data.Envelope;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.schema.DataCollectionSchema;
import io.debezium.util.Clock;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.ConnectHeaders;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class SpannerChangeRecordEmitterTest {
    SpannerChangeRecordEmitterTest() {
    }

    @Test
    void testConstructor() {
        MissingNode keysJsonNode = MissingNode.getInstance();
        MissingNode oldValuesJsonNode = MissingNode.getInstance();
        Mod mod = new Mod(0, (JsonNode)keysJsonNode, (JsonNode)oldValuesJsonNode, (JsonNode)MissingNode.getInstance());
        SpannerPartition initialSpannerPartition = SpannerPartition.getInitialSpannerPartition();
        SpannerChangeRecordEmitter actualSpannerChangeRecordEmitter = new SpannerChangeRecordEmitter("1234", ModType.INSERT, mod, initialSpannerPartition, (SpannerOffsetContext)Mockito.mock(SpannerOffsetContext.class), (Clock)Mockito.mock(Clock.class));
        SpannerPartition partition = (SpannerPartition)actualSpannerChangeRecordEmitter.getPartition();
        Assertions.assertSame((Object)initialSpannerPartition, (Object)partition);
        Assertions.assertEquals((Object)Envelope.Operation.CREATE, (Object)actualSpannerChangeRecordEmitter.getOperation());
        Map sourcePartition = partition.getSourcePartition();
        Assertions.assertEquals((int)1, (int)sourcePartition.size());
        Assertions.assertEquals((Object)"Parent0", sourcePartition.get("partitionToken"));
        Assertions.assertTrue((boolean)partition.getLoggingContext().isEmpty());
        Assertions.assertEquals((Object)"Parent0", (Object)partition.getValue());
    }

    private static Stream<Arguments> summaryStringProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{ModType.INSERT, Envelope.Operation.CREATE}), Arguments.of((Object[])new Object[]{ModType.UPDATE, Envelope.Operation.UPDATE}), Arguments.of((Object[])new Object[]{ModType.DELETE, Envelope.Operation.DELETE}));
    }

    @ParameterizedTest
    @MethodSource(value={"summaryStringProvider"})
    void testGetOperation(ModType modType, Envelope.Operation expected) {
        Mod mod = new Mod(0, (JsonNode)MissingNode.getInstance(), (JsonNode)MissingNode.getInstance(), (JsonNode)MissingNode.getInstance());
        Assertions.assertEquals((Object)expected, (Object)new SpannerChangeRecordEmitter("1234", modType, mod, SpannerPartition.getInitialSpannerPartition(), (SpannerOffsetContext)Mockito.mock(SpannerOffsetContext.class), (Clock)Mockito.mock(Clock.class)).getOperation());
    }

    @Test
    void testEmitChangeRecords() throws InterruptedException {
        SpannerOffsetContext spannerOffsetContext = (SpannerOffsetContext)Mockito.mock(SpannerOffsetContext.class);
        Mockito.when((Object)spannerOffsetContext.getSourceInfo()).thenReturn(null);
        Clock clock = (Clock)Mockito.mock(Clock.class);
        LocalDateTime atStartOfDayResult = LocalDate.of(1970, 1, 1).atStartOfDay();
        Mockito.when((Object)clock.currentTimeAsInstant()).thenReturn((Object)atStartOfDayResult.atZone(ZoneId.of("UTC")).toInstant());
        MissingNode keysJsonNode = MissingNode.getInstance();
        MissingNode oldValuesJsonNode = MissingNode.getInstance();
        Mod mod = new Mod(0, (JsonNode)keysJsonNode, (JsonNode)oldValuesJsonNode, (JsonNode)MissingNode.getInstance());
        SpannerChangeRecordEmitter spannerChangeRecordEmitter = (SpannerChangeRecordEmitter)Mockito.spy((Object)new SpannerChangeRecordEmitter("1234", ModType.INSERT, mod, SpannerPartition.getInitialSpannerPartition(), spannerOffsetContext, clock));
        Function function = (Function)Mockito.mock(Function.class);
        Mockito.when((Object)((Struct)function.apply((Mod)Mockito.any()))).thenThrow(new Throwable[]{new IllegalArgumentException()});
        TableId id = TableId.getTableId((String)"Table Name");
        ConnectSchema keySchema = new ConnectSchema(Schema.Type.INT8);
        Envelope envelopeSchema = new Envelope((Schema)new ConnectSchema(Schema.Type.INT8));
        KafkaSpannerTableSchema kafkaSpannerTableSchema = new KafkaSpannerTableSchema(id, (Schema)keySchema, function, envelopeSchema, (Schema)new ConnectSchema(Schema.Type.INT8), (Function)Mockito.mock(Function.class), (Function)Mockito.mock(Function.class));
        ((SpannerChangeRecordEmitter)Mockito.doNothing().when((Object)spannerChangeRecordEmitter)).emitCreateRecord((ChangeRecordEmitter.Receiver)Mockito.any(), (KafkaSpannerTableSchema)Mockito.any());
        ((SpannerChangeRecordEmitter)Mockito.doNothing().when((Object)spannerChangeRecordEmitter)).emitUpdateRecord((ChangeRecordEmitter.Receiver)Mockito.any(), (KafkaSpannerTableSchema)Mockito.any());
        ((SpannerChangeRecordEmitter)Mockito.doNothing().when((Object)spannerChangeRecordEmitter)).emitDeleteRecord((ChangeRecordEmitter.Receiver)Mockito.any(), (KafkaSpannerTableSchema)Mockito.any());
        Mockito.when((Object)spannerChangeRecordEmitter.getOperation()).thenReturn((Object)Envelope.Operation.CREATE);
        spannerChangeRecordEmitter.emitChangeRecords((DataCollectionSchema)kafkaSpannerTableSchema, null);
        ((SpannerChangeRecordEmitter)Mockito.verify((Object)spannerChangeRecordEmitter)).emitCreateRecord((ChangeRecordEmitter.Receiver)Mockito.any(), (KafkaSpannerTableSchema)Mockito.any());
        Mockito.when((Object)spannerChangeRecordEmitter.getOperation()).thenReturn((Object)Envelope.Operation.UPDATE);
        spannerChangeRecordEmitter.emitChangeRecords((DataCollectionSchema)kafkaSpannerTableSchema, null);
        ((SpannerChangeRecordEmitter)Mockito.verify((Object)spannerChangeRecordEmitter)).emitUpdateRecord((ChangeRecordEmitter.Receiver)Mockito.any(), (KafkaSpannerTableSchema)Mockito.any());
        Mockito.when((Object)spannerChangeRecordEmitter.getOperation()).thenReturn((Object)Envelope.Operation.DELETE);
        spannerChangeRecordEmitter.emitChangeRecords((DataCollectionSchema)kafkaSpannerTableSchema, null);
        ((SpannerChangeRecordEmitter)Mockito.verify((Object)spannerChangeRecordEmitter)).emitDeleteRecord((ChangeRecordEmitter.Receiver)Mockito.any(), (KafkaSpannerTableSchema)Mockito.any());
        Mockito.when((Object)spannerChangeRecordEmitter.getOperation()).thenReturn((Object)Envelope.Operation.READ);
        Assertions.assertThrows(IllegalArgumentException.class, () -> spannerChangeRecordEmitter.emitChangeRecords((DataCollectionSchema)kafkaSpannerTableSchema, null));
    }

    @Test
    void testEmitCreateRecord() throws InterruptedException {
        SpannerOffsetContext spannerOffsetContext = (SpannerOffsetContext)Mockito.mock(SpannerOffsetContext.class);
        Mockito.when((Object)spannerOffsetContext.getSourceInfo()).thenReturn(null);
        Clock clock = (Clock)Mockito.mock(Clock.class);
        LocalDateTime atStartOfDayResult = LocalDate.of(1970, 1, 1).atStartOfDay();
        Mockito.when((Object)clock.currentTimeAsInstant()).thenReturn((Object)atStartOfDayResult.atZone(ZoneId.of("UTC")).toInstant());
        MissingNode keysJsonNode = MissingNode.getInstance();
        MissingNode oldValuesJsonNode = MissingNode.getInstance();
        Mod mod = new Mod(0, (JsonNode)keysJsonNode, (JsonNode)oldValuesJsonNode, (JsonNode)MissingNode.getInstance());
        SpannerChangeRecordEmitter spannerChangeRecordEmitter = (SpannerChangeRecordEmitter)Mockito.spy((Object)new SpannerChangeRecordEmitter("1234", ModType.INSERT, mod, SpannerPartition.getInitialSpannerPartition(), spannerOffsetContext, clock));
        Function function = (Function)Mockito.mock(Function.class);
        Mockito.when((Object)((Struct)function.apply((Mod)Mockito.any()))).thenThrow(new Throwable[]{new IllegalArgumentException()});
        TableId id = TableId.getTableId((String)"Table Name");
        ConnectSchema keySchema = new ConnectSchema(Schema.Type.STRUCT);
        Envelope envelopeSchema = new Envelope((Schema)new ConnectSchema(Schema.Type.STRUCT));
        KafkaSpannerTableSchema kafkaSpannerTableSchema = (KafkaSpannerTableSchema)Mockito.spy((Object)new KafkaSpannerTableSchema(id, (Schema)keySchema, function, envelopeSchema, (Schema)new ConnectSchema(Schema.Type.STRUCT), (Function)Mockito.mock(Function.class), (Function)Mockito.mock(Function.class)));
        ChangeRecordEmitter.Receiver receiver = (ChangeRecordEmitter.Receiver)Mockito.mock(ChangeRecordEmitter.Receiver.class);
        ((ChangeRecordEmitter.Receiver)Mockito.doNothing().when((Object)receiver)).changeRecord((Partition)((SpannerPartition)Mockito.any()), (DataCollectionSchema)Mockito.any(), (Envelope.Operation)Mockito.any(), Mockito.any(), (Struct)Mockito.any(), (OffsetContext)Mockito.any(), (ConnectHeaders)Mockito.any());
        ((KafkaSpannerTableSchema)Mockito.doReturn(null).when((Object)kafkaSpannerTableSchema)).getKeyStructFromMod((Mod)Mockito.any());
        ((KafkaSpannerTableSchema)Mockito.doReturn(null).when((Object)kafkaSpannerTableSchema)).getNewValueStructFromMod((Mod)Mockito.any());
        ((SpannerChangeRecordEmitter)Mockito.doReturn(null).when((Object)spannerChangeRecordEmitter)).getEnvelopeCreate((KafkaSpannerTableSchema)Mockito.any(), (Struct)Mockito.any());
        ((SpannerChangeRecordEmitter)Mockito.doReturn(null).when((Object)spannerChangeRecordEmitter)).getEnvelopeUpdate((KafkaSpannerTableSchema)Mockito.any(), (Struct)Mockito.any(), (Struct)Mockito.any());
        ((SpannerChangeRecordEmitter)Mockito.doReturn(null).when((Object)spannerChangeRecordEmitter)).getEnvelopeDelete((KafkaSpannerTableSchema)Mockito.any(), (Struct)Mockito.any());
        spannerChangeRecordEmitter.emitCreateRecord(receiver, kafkaSpannerTableSchema);
        spannerChangeRecordEmitter.emitUpdateRecord(receiver, kafkaSpannerTableSchema);
        spannerChangeRecordEmitter.emitDeleteRecord(receiver, kafkaSpannerTableSchema);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> spannerChangeRecordEmitter.emitReadRecord(receiver, kafkaSpannerTableSchema));
        ((ChangeRecordEmitter.Receiver)Mockito.verify((Object)receiver, (VerificationMode)Mockito.times((int)3))).changeRecord((Partition)((SpannerPartition)Mockito.any()), (DataCollectionSchema)Mockito.any(), (Envelope.Operation)Mockito.any(), Mockito.any(), (Struct)Mockito.any(), (OffsetContext)Mockito.any(), (ConnectHeaders)Mockito.any());
    }

    @Test
    void testGetEnvelopeThrows() {
        SpannerOffsetContext spannerOffsetContext = (SpannerOffsetContext)Mockito.mock(SpannerOffsetContext.class);
        Mockito.when((Object)spannerOffsetContext.getSourceInfo()).thenReturn(null);
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Mockito.when((Object)clock.currentTimeAsInstant()).thenThrow(new Throwable[]{new IllegalArgumentException()});
        MissingNode keysJsonNode = MissingNode.getInstance();
        MissingNode oldValuesJsonNode = MissingNode.getInstance();
        Mod mod = new Mod(0, (JsonNode)keysJsonNode, (JsonNode)oldValuesJsonNode, (JsonNode)MissingNode.getInstance());
        SpannerChangeRecordEmitter spannerChangeRecordEmitter = new SpannerChangeRecordEmitter("1234", ModType.INSERT, mod, SpannerPartition.getInitialSpannerPartition(), spannerOffsetContext, clock);
        TableId id = TableId.getTableId((String)"Table Name");
        ConnectSchema keySchema = new ConnectSchema(Schema.Type.INT8);
        Function keyGenerator = (Function)Mockito.mock(Function.class);
        Envelope envelopeSchema = new Envelope((Schema)new ConnectSchema(Schema.Type.INT8));
        KafkaSpannerTableSchema kafkaSpannerTableSchema = new KafkaSpannerTableSchema(id, (Schema)keySchema, keyGenerator, envelopeSchema, (Schema)new ConnectSchema(Schema.Type.INT8), (Function)Mockito.mock(Function.class), (Function)Mockito.mock(Function.class));
        Assertions.assertThrows(IllegalArgumentException.class, () -> spannerChangeRecordEmitter.getEnvelopeCreate(kafkaSpannerTableSchema, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> spannerChangeRecordEmitter.getEnvelopeUpdate(kafkaSpannerTableSchema, null, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> spannerChangeRecordEmitter.getEnvelopeDelete(kafkaSpannerTableSchema, null));
        ((SpannerOffsetContext)Mockito.verify((Object)spannerOffsetContext, (VerificationMode)Mockito.times((int)3))).getSourceInfo();
        ((Clock)Mockito.verify((Object)clock, (VerificationMode)Mockito.times((int)3))).currentTimeAsInstant();
    }

    @Test
    void testEmitReadRecord() {
        MissingNode keysJsonNode = MissingNode.getInstance();
        MissingNode oldValuesJsonNode = MissingNode.getInstance();
        Mod mod = new Mod(0, (JsonNode)keysJsonNode, (JsonNode)oldValuesJsonNode, (JsonNode)MissingNode.getInstance());
        SpannerChangeRecordEmitter spannerChangeRecordEmitter = new SpannerChangeRecordEmitter("1234", ModType.INSERT, mod, SpannerPartition.getInitialSpannerPartition(), (SpannerOffsetContext)Mockito.mock(SpannerOffsetContext.class), (Clock)Mockito.mock(Clock.class));
        TableId id = TableId.getTableId((String)"Table Name");
        ConnectSchema keySchema = new ConnectSchema(Schema.Type.INT8);
        Function keyGenerator = (Function)Mockito.mock(Function.class);
        Envelope envelopeSchema = new Envelope((Schema)new ConnectSchema(Schema.Type.INT8));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> spannerChangeRecordEmitter.emitReadRecord(null, new KafkaSpannerTableSchema(id, (Schema)keySchema, keyGenerator, envelopeSchema, (Schema)new ConnectSchema(Schema.Type.INT8), (Function)Mockito.mock(Function.class), (Function)Mockito.mock(Function.class))));
    }
}

