/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db.stream;

import io.debezium.connector.spanner.db.model.StreamEventMetadata;
import io.debezium.connector.spanner.db.model.event.ChangeStreamEvent;
import io.debezium.connector.spanner.db.stream.PartitionQueryingMonitor;
import io.debezium.connector.spanner.db.stream.PartitionThreadPool;
import io.debezium.connector.spanner.metrics.MetricsEventPublisher;
import io.debezium.function.BlockingConsumer;
import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class PartitionQueryingMonitorTest {
    PartitionQueryingMonitorTest() {
    }

    @Test
    void testStart() {
        PartitionThreadPool partitionThreadPool = (PartitionThreadPool)Mockito.spy((Object)new PartitionThreadPool());
        ((PartitionThreadPool)Mockito.doReturn(Set.of("1", "2")).when((Object)partitionThreadPool)).getActiveThreads();
        BlockingConsumer onStuckPartitionConsumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
        Consumer errorConsumer = (Consumer)Mockito.mock(Consumer.class);
        PartitionQueryingMonitor partitionQueryingMonitor = (PartitionQueryingMonitor)Mockito.spy((Object)new PartitionQueryingMonitor(partitionThreadPool, Duration.ofMillis(1L), onStuckPartitionConsumer, errorConsumer, new MetricsEventPublisher(), 2));
        partitionQueryingMonitor.stop();
        partitionQueryingMonitor.start();
        int stuckHeartbeatIntervals = partitionQueryingMonitor.stuckHeartbeatIntervals(Instant.now().minusSeconds(5L));
        Assertions.assertTrue((boolean)partitionQueryingMonitor.isPartitionStuck(Instant.now().minusSeconds(5L)));
        Assertions.assertTrue((stuckHeartbeatIntervals > 0 ? 1 : 0) != 0);
    }

    @Test
    void testAcceptStreamEvent() {
        PartitionThreadPool partitionThreadPool = new PartitionThreadPool();
        BlockingConsumer onStuckPartitionConsumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
        Consumer errorConsumer = (Consumer)Mockito.mock(Consumer.class);
        PartitionQueryingMonitor partitionQueryingMonitor = new PartitionQueryingMonitor(partitionThreadPool, Duration.ofSeconds(1L), onStuckPartitionConsumer, errorConsumer, new MetricsEventPublisher(), 3);
        ChangeStreamEvent changeStreamEvent = (ChangeStreamEvent)Mockito.mock(ChangeStreamEvent.class);
        StreamEventMetadata streamEventMetadata = (StreamEventMetadata)Mockito.mock(StreamEventMetadata.class);
        ((ChangeStreamEvent)Mockito.doReturn((Object)streamEventMetadata).when((Object)changeStreamEvent)).getMetadata();
        ((StreamEventMetadata)Mockito.doReturn((Object)"token").when((Object)streamEventMetadata)).getPartitionToken();
        partitionQueryingMonitor.acceptStreamEvent(changeStreamEvent);
        ((ChangeStreamEvent)Mockito.verify((Object)changeStreamEvent)).getMetadata();
        ((StreamEventMetadata)Mockito.verify((Object)streamEventMetadata)).getPartitionToken();
    }
}

