/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db.dao;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ForwardingAsyncResultSet;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import io.debezium.connector.spanner.db.dao.SchemaDao;
import io.debezium.connector.spanner.db.metadata.TableId;
import io.debezium.connector.spanner.db.model.schema.ChangeStreamSchema;
import io.debezium.connector.spanner.db.model.schema.SpannerSchema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class SchemaDaoTest {
    SchemaDaoTest() {
    }

    @Test
    void testGetSchema() throws SpannerException {
        AsyncResultSet asyncResultSet = (AsyncResultSet)Mockito.mock(AsyncResultSet.class);
        Mockito.when((Object)asyncResultSet.getBoolean(Mockito.anyInt())).thenReturn((Object)true);
        Mockito.when((Object)asyncResultSet.getString(Mockito.anyInt())).thenReturn((Object)"String");
        Mockito.when((Object)asyncResultSet.getLong(Mockito.anyInt())).thenReturn((Object)1L);
        Mockito.when((Object)asyncResultSet.next()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        new ForwardingAsyncResultSet((AsyncResultSet)new ForwardingAsyncResultSet((AsyncResultSet)new ForwardingAsyncResultSet((AsyncResultSet)new ForwardingAsyncResultSet((AsyncResultSet)new ForwardingAsyncResultSet(asyncResultSet)))));
        DatabaseClient databaseClient = (DatabaseClient)Mockito.mock(DatabaseClient.class);
        ReadOnlyTransaction readOnlyTransaction = (ReadOnlyTransaction)Mockito.mock(ReadOnlyTransaction.class);
        Mockito.when((Object)databaseClient.readOnlyTransaction((TimestampBound)Mockito.any())).thenReturn((Object)readOnlyTransaction);
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)resultSet.getString(0)).thenReturn((Object)"tableName");
        Mockito.when((Object)resultSet.getString(1)).thenReturn((Object)"columnName");
        Mockito.when((Object)resultSet.getString(2)).thenReturn((Object)"BOOL");
        Mockito.when((Object)resultSet.getLong(3)).thenReturn((Object)10L);
        Mockito.when((Object)resultSet.getBoolean(4)).thenReturn((Object)true);
        Mockito.when((Object)resultSet.getBoolean(5)).thenReturn((Object)true);
        Mockito.when((Object)resultSet.next()).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)readOnlyTransaction.executeQuery((Statement)Mockito.any(), new Options.QueryOption[0])).thenReturn((Object)resultSet);
        SchemaDao schemaDao = new SchemaDao(databaseClient);
        SpannerSchema schema = schemaDao.getSchema(Timestamp.ofTimeMicroseconds((long)1L));
        Assertions.assertFalse((boolean)schema.getAllTables().isEmpty());
        Assertions.assertEquals((int)1, (int)schema.getAllTables().size());
        Assertions.assertEquals((Object)"tableName", (Object)((TableId)schema.getAllTables().iterator().next()).getTableName());
    }

    @Test
    void testGetStream() throws SpannerException {
        AsyncResultSet asyncResultSet = (AsyncResultSet)Mockito.mock(AsyncResultSet.class);
        Mockito.when((Object)asyncResultSet.getBoolean(Mockito.anyInt())).thenReturn((Object)true);
        Mockito.when((Object)asyncResultSet.getString(Mockito.anyInt())).thenReturn((Object)"String");
        Mockito.when((Object)asyncResultSet.next()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        ReadOnlyTransaction readOnlyTransaction = (ReadOnlyTransaction)Mockito.mock(ReadOnlyTransaction.class);
        Mockito.when((Object)readOnlyTransaction.executeQuery((Statement)Mockito.any(), (Options.QueryOption[])Mockito.any())).thenReturn((Object)new ForwardingAsyncResultSet((AsyncResultSet)new ForwardingAsyncResultSet((AsyncResultSet)new ForwardingAsyncResultSet((AsyncResultSet)new ForwardingAsyncResultSet((AsyncResultSet)new ForwardingAsyncResultSet(asyncResultSet))))));
        ((ReadOnlyTransaction)Mockito.doNothing().when((Object)readOnlyTransaction)).close();
        DatabaseClient databaseClient = (DatabaseClient)Mockito.mock(DatabaseClient.class);
        Mockito.when((Object)databaseClient.readOnlyTransaction((TimestampBound)Mockito.any())).thenReturn((Object)readOnlyTransaction);
        SchemaDao schemaDao = new SchemaDao(databaseClient);
        ChangeStreamSchema actualStream = schemaDao.getStream(Timestamp.ofTimeMicroseconds((long)1L), "Stream Name");
        Assertions.assertEquals((Object)"Stream Name", (Object)actualStream.getName());
        Assertions.assertTrue((boolean)actualStream.isWatchedAllTables());
        ((DatabaseClient)Mockito.verify((Object)databaseClient)).readOnlyTransaction((TimestampBound)Mockito.any());
        ((ReadOnlyTransaction)Mockito.verify((Object)readOnlyTransaction)).executeQuery((Statement)Mockito.any(), (Options.QueryOption[])Mockito.any());
        ((ReadOnlyTransaction)Mockito.verify((Object)readOnlyTransaction)).close();
        ((AsyncResultSet)Mockito.verify((Object)asyncResultSet, (VerificationMode)Mockito.atLeast((int)1))).next();
        ((AsyncResultSet)Mockito.verify((Object)asyncResultSet, (VerificationMode)Mockito.atLeast((int)1))).getBoolean(Mockito.anyInt());
    }
}

