/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db;

import com.google.cloud.spanner.DatabaseClient;
import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.connector.spanner.db.DatabaseClientFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class DatabaseClientFactoryTest {
    DatabaseClientFactoryTest() {
    }

    @Test
    void testConstructor() {
        SpannerConnectorConfig spannerConnectorConfig = (SpannerConnectorConfig)Mockito.mock(SpannerConnectorConfig.class);
        Mockito.when((Object)spannerConnectorConfig.databaseId()).thenReturn((Object)"42");
        Mockito.when((Object)spannerConnectorConfig.gcpSpannerCredentialsJson()).thenReturn((Object)"Gcp Spanner Credentials Json");
        Mockito.when((Object)spannerConnectorConfig.gcpSpannerCredentialsPath()).thenReturn((Object)"Gcp Spanner Credentials Path");
        Mockito.when((Object)spannerConnectorConfig.instanceId()).thenReturn((Object)"42");
        Mockito.when((Object)spannerConnectorConfig.projectId()).thenReturn((Object)"myproject");
        new DatabaseClientFactory(spannerConnectorConfig);
        ((SpannerConnectorConfig)Mockito.verify((Object)spannerConnectorConfig)).databaseId();
        ((SpannerConnectorConfig)Mockito.verify((Object)spannerConnectorConfig)).gcpSpannerCredentialsJson();
        ((SpannerConnectorConfig)Mockito.verify((Object)spannerConnectorConfig)).gcpSpannerCredentialsPath();
        ((SpannerConnectorConfig)Mockito.verify((Object)spannerConnectorConfig)).instanceId();
        ((SpannerConnectorConfig)Mockito.verify((Object)spannerConnectorConfig)).projectId();
    }

    @Test
    void testGetGoogleCredentials() {
        Assertions.assertNull((Object)new DatabaseClientFactory("myproject", "42", "42", "Credentials Json", "Credentials Path", null).getGoogleCredentials("Credentials Json", "Credentials Path"));
        Assertions.assertNull((Object)new DatabaseClientFactory("myproject", "42", "42", "Credentials Json", "Credentials Path", null).getGoogleCredentials(null, null));
        Assertions.assertNull((Object)new DatabaseClientFactory("myproject", "42", "42", "Credentials Json", "Credentials Path", null).getGoogleCredentials(null, "Credentials Path"));
    }

    @Test
    void testGetDatabaseClient() {
        DatabaseClientFactory databaseClientFactory = new DatabaseClientFactory("myproject", "42", "42", "Credentials Json", "Credentials Path", null);
        DatabaseClient actualDatabaseClient = databaseClientFactory.getDatabaseClient();
        Assertions.assertNotNull((Object)actualDatabaseClient);
    }
}

