/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.context.offset;

import com.google.cloud.Timestamp;
import io.debezium.connector.spanner.context.offset.PartitionOffset;
import io.debezium.connector.spanner.db.model.StreamEventMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class PartitionOffsetHolderTest {
    PartitionOffsetHolderTest() {
    }

    private static Stream<Arguments> offsetProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{Timestamp.ofTimeMicroseconds((long)1L), 3, Timestamp.ofTimeMicroseconds((long)1L).toString()}), Arguments.of((Object[])new Object[]{Timestamp.ofTimeMicroseconds((long)0L), 3, Timestamp.ofTimeMicroseconds((long)0L).toSqlTimestamp().toInstant().toString()}));
    }

    @ParameterizedTest
    @MethodSource(value={"offsetProvider"})
    void testGetOffset(Timestamp timestamp, int expectedSize, String expectedOffset) {
        PartitionOffset partitionOffsetHolder = new PartitionOffset(timestamp, StreamEventMetadata.newBuilder().withPartitionStartTimestamp(Timestamp.now()).build());
        Map actualOffset = partitionOffsetHolder.getOffset();
        Assertions.assertEquals((int)expectedSize, (int)actualOffset.size());
        Assertions.assertEquals((Object)expectedOffset, actualOffset.get("offset"));
    }

    @Test
    void testUpdatePartitionOffset() {
        PartitionOffset partitionOffsetHolder = new PartitionOffset(Timestamp.ofTimeMicroseconds((long)1L), StreamEventMetadata.newBuilder().withPartitionStartTimestamp(Timestamp.now()).build());
        Assertions.assertEquals((int)3, (int)partitionOffsetHolder.getOffset().size());
    }

    @Test
    void testExtractOffset() {
        Assertions.assertNull((Object)PartitionOffset.extractOffset(new HashMap()));
        HashMap<String, String> stringStringMap = new HashMap<String, String>();
        Timestamp timestamp = Timestamp.ofTimeMicroseconds((long)1L);
        stringStringMap.put("offset", timestamp.toSqlTimestamp().toInstant().toString());
        Assertions.assertEquals((Object)timestamp, (Object)PartitionOffset.extractOffset(stringStringMap));
    }
}

