/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.config;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.connector.spanner.config.SpannerTableFilter;
import io.debezium.connector.spanner.db.metadata.TableId;
import java.util.Properties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class SpannerTableFilterTest {
    SpannerTableFilterTest() {
    }

    @Test
    void testConstructor() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        SpannerTableFilter actualSpannerTableFilter = new SpannerTableFilter(new SpannerConnectorConfig(configuration));
        boolean actualIsIncludedResult = actualSpannerTableFilter.isIncluded(TableId.getTableId((String)"Table Name"));
        Assertions.assertTrue((boolean)actualIsIncludedResult);
    }

    @Test
    void isIncludedWithExcludeList() {
        SpannerConnectorConfig connectorConfig = (SpannerConnectorConfig)Mockito.mock(SpannerConnectorConfig.class);
        Mockito.when((Object)connectorConfig.tableExcludeList()).thenReturn((Object)"TestTable");
        Mockito.when((Object)connectorConfig.tableIncludeList()).thenReturn(null);
        SpannerTableFilter spannerTableFilter = new SpannerTableFilter(connectorConfig);
        boolean included = spannerTableFilter.isIncluded(TableId.getTableId((String)"TestTable"));
        Assertions.assertFalse((boolean)included);
        included = spannerTableFilter.isIncluded(TableId.getTableId((String)"Table"));
        Assertions.assertTrue((boolean)included);
    }

    @Test
    void isIncludedWithIncludeList() {
        SpannerConnectorConfig connectorConfig = (SpannerConnectorConfig)Mockito.mock(SpannerConnectorConfig.class);
        Mockito.when((Object)connectorConfig.tableExcludeList()).thenReturn(null);
        Mockito.when((Object)connectorConfig.tableIncludeList()).thenReturn((Object)"TestTable");
        SpannerTableFilter spannerTableFilter = new SpannerTableFilter(connectorConfig);
        boolean included = spannerTableFilter.isIncluded(TableId.getTableId((String)"TestTable"));
        Assertions.assertTrue((boolean)included);
        included = spannerTableFilter.isIncluded(TableId.getTableId((String)"Table"));
        Assertions.assertFalse((boolean)included);
    }

    @Test
    void isIncludedNoLists() {
        SpannerConnectorConfig connectorConfig = (SpannerConnectorConfig)Mockito.mock(SpannerConnectorConfig.class);
        Mockito.when((Object)connectorConfig.tableExcludeList()).thenReturn(null);
        Mockito.when((Object)connectorConfig.tableIncludeList()).thenReturn(null);
        SpannerTableFilter spannerTableFilter = new SpannerTableFilter(connectorConfig);
        boolean included = spannerTableFilter.isIncluded(TableId.getTableId((String)"TestTable"));
        Assertions.assertTrue((boolean)included);
        included = spannerTableFilter.isIncluded(TableId.getTableId((String)"Table"));
        Assertions.assertTrue((boolean)included);
    }

    @Test
    void isIncludedWithRegExpExpressions() {
        SpannerConnectorConfig connectorConfig = (SpannerConnectorConfig)Mockito.mock(SpannerConnectorConfig.class);
        Mockito.when((Object)connectorConfig.tableExcludeList()).thenReturn(null);
        Mockito.when((Object)connectorConfig.tableIncludeList()).thenReturn((Object)".*Account");
        SpannerTableFilter spannerTableFilter = new SpannerTableFilter(connectorConfig);
        boolean included = spannerTableFilter.isIncluded(TableId.getTableId((String)"userAccount"));
        Assertions.assertTrue((boolean)included);
        included = spannerTableFilter.isIncluded(TableId.getTableId((String)"userInfo"));
        Assertions.assertFalse((boolean)included);
    }

    @Test
    void testIsIncluded() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        SpannerTableFilter spannerTableFilter = new SpannerTableFilter(new SpannerConnectorConfig(configuration));
        Assertions.assertTrue((boolean)spannerTableFilter.isIncluded(TableId.getTableId((String)"Table Name")));
    }
}

