/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseClient;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.spanner.PartitionManager;
import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.connector.spanner.SpannerPartition;
import io.debezium.connector.spanner.SpannerStreamingChangeEventSource;
import io.debezium.connector.spanner.StreamEventQueue;
import io.debezium.connector.spanner.config.SpannerTableFilter;
import io.debezium.connector.spanner.context.offset.LowWatermarkProvider;
import io.debezium.connector.spanner.context.offset.SpannerOffsetContextFactory;
import io.debezium.connector.spanner.context.source.SourceInfoFactory;
import io.debezium.connector.spanner.db.dao.SchemaDao;
import io.debezium.connector.spanner.db.metadata.SchemaRegistry;
import io.debezium.connector.spanner.db.metadata.TableId;
import io.debezium.connector.spanner.db.model.ModType;
import io.debezium.connector.spanner.db.model.StreamEventMetadata;
import io.debezium.connector.spanner.db.model.ValueCaptureType;
import io.debezium.connector.spanner.db.model.event.DataChangeEvent;
import io.debezium.connector.spanner.kafka.KafkaPartitionInfoProvider;
import io.debezium.connector.spanner.metrics.MetricsEventPublisher;
import io.debezium.connector.spanner.processor.SpannerEventDispatcher;
import io.debezium.connector.spanner.processor.metadata.SpannerEventMetadataProvider;
import io.debezium.connector.spanner.schema.KafkaSpannerSchema;
import io.debezium.connector.spanner.schema.KafkaSpannerTableSchemaFactory;
import io.debezium.connector.spanner.task.SynchronizedPartitionManager;
import io.debezium.function.BlockingConsumer;
import io.debezium.heartbeat.HeartbeatFactory;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.metrics.DefaultChangeEventSourceMetricsFactory;
import io.debezium.pipeline.metrics.spi.ChangeEventSourceMetricsFactory;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.ChangeEventCreator;
import io.debezium.schema.DataCollectionFilters;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.spi.topic.TopicNamingStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.source.SourceRecord;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class SpannerStreamingChangeEventSourceTest {
    SpannerStreamingChangeEventSourceTest() {
    }

    @Disabled
    @Test
    void testExecute() throws InterruptedException {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        SpannerConnectorConfig connectorConfig = new SpannerConnectorConfig(configuration);
        ChangeEventQueue changeEventQueue = (ChangeEventQueue)Mockito.mock(ChangeEventQueue.class);
        ((ChangeEventQueue)Mockito.doNothing().when((Object)changeEventQueue)).producerException((RuntimeException)Mockito.any());
        ErrorHandler errorHandler = new ErrorHandler(SourceConnector.class, (CommonConnectorConfig)connectorConfig, changeEventQueue);
        Configuration configuration1 = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration1.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration1.asProperties()).thenReturn((Object)new Properties());
        SpannerConnectorConfig connectorConfig1 = new SpannerConnectorConfig(configuration1);
        TopicNamingStrategy topicNamingStrategy = (TopicNamingStrategy)Mockito.mock(TopicNamingStrategy.class);
        Mockito.when((Object)topicNamingStrategy.transactionTopic()).thenReturn((Object)"Transaction Topic");
        Configuration configuration2 = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration2.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration2.asProperties()).thenReturn((Object)new Properties());
        SpannerTableFilter filter = new SpannerTableFilter(new SpannerConnectorConfig(configuration2));
        Configuration configuration3 = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration3.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration3.asProperties()).thenReturn((Object)new Properties());
        SpannerConnectorConfig connectorConfig2 = new SpannerConnectorConfig(configuration3);
        TopicNamingStrategy topicNamingStrategy1 = (TopicNamingStrategy)Mockito.mock(TopicNamingStrategy.class);
        Mockito.when((Object)topicNamingStrategy1.heartbeatTopic()).thenReturn((Object)"Heartbeat Topic");
        SchemaNameAdjuster schemaNameAdjuster = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        Mockito.when((Object)schemaNameAdjuster.adjust((String)Mockito.any())).thenReturn((Object)"Adjust");
        HeartbeatFactory heartbeatFactory = new HeartbeatFactory((CommonConnectorConfig)connectorConfig2, topicNamingStrategy1, schemaNameAdjuster);
        SchemaNameAdjuster schemaNameAdjuster1 = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        Mockito.when((Object)schemaNameAdjuster1.adjust((String)Mockito.any())).thenReturn((Object)"Adjust");
        Configuration configuration4 = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration4.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration4.asProperties()).thenReturn((Object)new Properties());
        SourceInfoFactory sourceInfoFactory = new SourceInfoFactory(new SpannerConnectorConfig(configuration4), (LowWatermarkProvider)Mockito.mock(LowWatermarkProvider.class));
        TopicNamingStrategy topicNamingStrategy2 = (TopicNamingStrategy)Mockito.mock(TopicNamingStrategy.class);
        SchemaNameAdjuster schemaNameAdjuster2 = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        SchemaRegistry schemaRegistry = new SchemaRegistry("Stream Name", (SchemaDao)Mockito.mock(SchemaDao.class), (Runnable)Mockito.mock(Runnable.class));
        KafkaSpannerSchema schema = new KafkaSpannerSchema(new KafkaSpannerTableSchemaFactory(topicNamingStrategy2, schemaNameAdjuster2, schemaRegistry, (Schema)new ConnectSchema(Schema.Type.INT8)));
        ChangeEventQueue queue = (ChangeEventQueue)Mockito.mock(ChangeEventQueue.class);
        ChangeEventCreator changeEventCreator = (ChangeEventCreator)Mockito.mock(ChangeEventCreator.class);
        SpannerEventMetadataProvider metadataProvider = new SpannerEventMetadataProvider();
        SchemaRegistry schemaRegistry1 = new SchemaRegistry("Stream Name", new SchemaDao((DatabaseClient)Mockito.mock(DatabaseClient.class)), (Runnable)Mockito.mock(Runnable.class));
        SpannerEventDispatcher spannerEventDispatcher = new SpannerEventDispatcher(connectorConfig1, topicNamingStrategy, (DatabaseSchema)schema, queue, (DataCollectionFilters.DataCollectionFilter)filter, changeEventCreator, (EventMetadataProvider)metadataProvider, heartbeatFactory, schemaNameAdjuster1, schemaRegistry1, sourceInfoFactory, new KafkaPartitionInfoProvider(null));
        StreamEventQueue eventQueue = new StreamEventQueue(3, new MetricsEventPublisher());
        MetricsEventPublisher metricsEventPublisher = new MetricsEventPublisher();
        SynchronizedPartitionManager partitionManager = new SynchronizedPartitionManager((BlockingConsumer)Mockito.mock(BlockingConsumer.class));
        SpannerStreamingChangeEventSource spannerStreamingChangeEventSource = new SpannerStreamingChangeEventSource(errorHandler, null, eventQueue, metricsEventPublisher, (PartitionManager)partitionManager, new SchemaRegistry("Stream Name", new SchemaDao((DatabaseClient)Mockito.mock(DatabaseClient.class)), (Runnable)Mockito.mock(Runnable.class)), spannerEventDispatcher, true, (SpannerOffsetContextFactory)Mockito.mock(SpannerOffsetContextFactory.class));
        Configuration configuration5 = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration5.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration5.asProperties()).thenReturn((Object)new Properties());
        SpannerConnectorConfig connectorConfig3 = new SpannerConnectorConfig(configuration5);
        ErrorHandler errorHandler1 = new ErrorHandler(SourceConnector.class, (CommonConnectorConfig)connectorConfig3, (ChangeEventQueue)Mockito.mock(ChangeEventQueue.class));
        Configuration configuration6 = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration6.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration6.asProperties()).thenReturn((Object)new Properties());
        SpannerConnectorConfig connectorConfig4 = new SpannerConnectorConfig(configuration6);
        Class<SourceConnector> connectorType = SourceConnector.class;
        ChangeEventSourceFactory changeEventSourceFactory = (ChangeEventSourceFactory)Mockito.mock(ChangeEventSourceFactory.class);
        ChangeEventSourceCoordinator.ChangeEventSourceContextImpl context = new ChangeEventSourceCoordinator.ChangeEventSourceContextImpl(new ChangeEventSourceCoordinator(null, errorHandler1, connectorType, (CommonConnectorConfig)connectorConfig4, changeEventSourceFactory, (ChangeEventSourceMetricsFactory)new DefaultChangeEventSourceMetricsFactory(), (EventDispatcher)Mockito.mock(EventDispatcher.class), (DatabaseSchema)Mockito.mock(DatabaseSchema.class)));
        SpannerPartition partition = SpannerPartition.getInitialSpannerPartition();
        Configuration configuration7 = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration7.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration7.asProperties()).thenReturn((Object)new Properties());
        spannerStreamingChangeEventSource.execute((ChangeEventSource.ChangeEventSourceContext)context, partition, null);
        ((Configuration)Mockito.verify((Object)configuration)).getString((Field)Mockito.any());
        ((Configuration)Mockito.verify((Object)configuration)).asProperties();
        ((ChangeEventQueue)Mockito.verify((Object)changeEventQueue)).producerException((RuntimeException)Mockito.any());
        ((Configuration)Mockito.verify((Object)configuration1)).getString((Field)Mockito.any());
        ((Configuration)Mockito.verify((Object)configuration1)).asProperties();
        ((TopicNamingStrategy)Mockito.verify((Object)topicNamingStrategy)).transactionTopic();
        ((Configuration)Mockito.verify((Object)configuration2)).getString((Field)Mockito.any());
        ((Configuration)Mockito.verify((Object)configuration2)).asProperties();
        ((Configuration)Mockito.verify((Object)configuration3)).getString((Field)Mockito.any());
        ((Configuration)Mockito.verify((Object)configuration3)).asProperties();
        ((TopicNamingStrategy)Mockito.verify((Object)topicNamingStrategy1)).heartbeatTopic();
        ((SchemaNameAdjuster)Mockito.verify((Object)schemaNameAdjuster, (VerificationMode)Mockito.atLeast((int)1))).adjust((String)Mockito.any());
        ((SchemaNameAdjuster)Mockito.verify((Object)schemaNameAdjuster1, (VerificationMode)Mockito.atLeast((int)1))).adjust((String)Mockito.any());
        ((Configuration)Mockito.verify((Object)configuration4)).getString((Field)Mockito.any());
        ((Configuration)Mockito.verify((Object)configuration4)).asProperties();
        ((Configuration)Mockito.verify((Object)configuration5)).getString((Field)Mockito.any());
        ((Configuration)Mockito.verify((Object)configuration5)).asProperties();
        ((Configuration)Mockito.verify((Object)configuration6)).getString((Field)Mockito.any());
        ((Configuration)Mockito.verify((Object)configuration6)).asProperties();
        ((Configuration)Mockito.verify((Object)configuration7)).getString((Field)Mockito.any());
        ((Configuration)Mockito.verify((Object)configuration7)).asProperties();
    }

    @Test
    void testProcessDataChangeEvent() throws InterruptedException {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((String)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        SpannerConnectorConfig connectorConfig = new SpannerConnectorConfig(configuration);
        ErrorHandler errorHandler = new ErrorHandler(SourceConnector.class, (CommonConnectorConfig)connectorConfig, (ChangeEventQueue)Mockito.mock(ChangeEventQueue.class));
        Configuration configuration1 = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration1.getString((String)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration1.asProperties()).thenReturn((Object)new Properties());
        SpannerConnectorConfig connectorConfig1 = new SpannerConnectorConfig(configuration1);
        TopicNamingStrategy topicNamingStrategy = (TopicNamingStrategy)Mockito.mock(TopicNamingStrategy.class);
        Mockito.when((Object)topicNamingStrategy.transactionTopic()).thenReturn((Object)"Transaction Topic");
        Configuration configuration2 = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration2.getString((String)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration2.asProperties()).thenReturn((Object)new Properties());
        SpannerTableFilter filter = new SpannerTableFilter(new SpannerConnectorConfig(configuration2));
        Configuration configuration3 = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration3.getString((String)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration3.asProperties()).thenReturn((Object)new Properties());
        SpannerConnectorConfig connectorConfig2 = new SpannerConnectorConfig(configuration3);
        TopicNamingStrategy topicNamingStrategy1 = (TopicNamingStrategy)Mockito.mock(TopicNamingStrategy.class);
        Mockito.when((Object)topicNamingStrategy1.heartbeatTopic()).thenReturn((Object)"Heartbeat Topic");
        SchemaNameAdjuster schemaNameAdjuster = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        Mockito.when((Object)schemaNameAdjuster.adjust((String)Mockito.any())).thenReturn((Object)"Adjust");
        HeartbeatFactory heartbeatFactory = new HeartbeatFactory((CommonConnectorConfig)connectorConfig2, topicNamingStrategy1, schemaNameAdjuster);
        SchemaNameAdjuster schemaNameAdjuster1 = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        Mockito.when((Object)schemaNameAdjuster1.adjust((String)Mockito.any())).thenReturn((Object)"Adjust");
        Configuration configuration4 = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration4.getString((String)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration4.asProperties()).thenReturn((Object)new Properties());
        SourceInfoFactory sourceInfoFactory = new SourceInfoFactory(new SpannerConnectorConfig(configuration4), (LowWatermarkProvider)Mockito.mock(LowWatermarkProvider.class));
        TopicNamingStrategy topicNamingStrategy2 = (TopicNamingStrategy)Mockito.mock(TopicNamingStrategy.class);
        SchemaNameAdjuster schemaNameAdjuster2 = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        SchemaRegistry schemaRegistry = new SchemaRegistry("Stream Name", (SchemaDao)Mockito.mock(SchemaDao.class), (Runnable)Mockito.mock(Runnable.class));
        KafkaSpannerSchema schema = new KafkaSpannerSchema(new KafkaSpannerTableSchemaFactory(topicNamingStrategy2, schemaNameAdjuster2, schemaRegistry, (Schema)new ConnectSchema(Schema.Type.INT8)));
        ChangeEventQueue queue = (ChangeEventQueue)Mockito.mock(ChangeEventQueue.class);
        ChangeEventCreator changeEventCreator = (ChangeEventCreator)Mockito.mock(ChangeEventCreator.class);
        SpannerEventMetadataProvider metadataProvider = new SpannerEventMetadataProvider();
        SchemaRegistry schemaRegistryDatabaseClient = (SchemaRegistry)Mockito.spy((Object)new SchemaRegistry("Stream Name", new SchemaDao((DatabaseClient)Mockito.mock(DatabaseClient.class)), (Runnable)Mockito.mock(Runnable.class)));
        SpannerEventDispatcher spannerEventDispatcher = new SpannerEventDispatcher(connectorConfig1, topicNamingStrategy, (DatabaseSchema)schema, queue, (DataCollectionFilters.DataCollectionFilter)filter, changeEventCreator, (EventMetadataProvider)metadataProvider, heartbeatFactory, schemaNameAdjuster1, schemaRegistryDatabaseClient, sourceInfoFactory, new KafkaPartitionInfoProvider(null));
        Configuration configuration5 = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration5.getString((String)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration5.asProperties()).thenReturn((Object)new Properties());
        SpannerOffsetContextFactory offsetContextFactory = new SpannerOffsetContextFactory(new SourceInfoFactory(new SpannerConnectorConfig(configuration5), (LowWatermarkProvider)Mockito.mock(LowWatermarkProvider.class)));
        StreamEventQueue eventQueue = new StreamEventQueue(3, new MetricsEventPublisher());
        MetricsEventPublisher metricsEventPublisher = new MetricsEventPublisher();
        SynchronizedPartitionManager partitionManager = new SynchronizedPartitionManager((BlockingConsumer)Mockito.mock(BlockingConsumer.class));
        ((SchemaRegistry)Mockito.doNothing().when((Object)schemaRegistryDatabaseClient)).checkSchema((TableId)Mockito.any(), (Timestamp)Mockito.any(), (List)Mockito.any());
        SpannerStreamingChangeEventSource spannerStreamingChangeEventSource = new SpannerStreamingChangeEventSource(errorHandler, null, eventQueue, metricsEventPublisher, (PartitionManager)partitionManager, schemaRegistryDatabaseClient, spannerEventDispatcher, true, offsetContextFactory);
        Timestamp commitTimestamp = Timestamp.ofTimeMicroseconds((long)1L);
        ArrayList rowType = new ArrayList();
        DataChangeEvent dataChangeEvent = (DataChangeEvent)Mockito.spy((Object)new DataChangeEvent("ABC123", commitTimestamp, "42", true, "Record Sequence", "Table Name", rowType, new ArrayList(), ModType.INSERT, ValueCaptureType.NEW_ROW, 1L, 1L, "Transaction Tag", true, (StreamEventMetadata)Mockito.mock(StreamEventMetadata.class)));
        spannerStreamingChangeEventSource.processDataChangeEvent(dataChangeEvent);
        ((DataChangeEvent)Mockito.verify((Object)dataChangeEvent)).getMods();
    }

    @Test
    void testCommitOffset() {
        SynchronizedPartitionManager partitionManager = (SynchronizedPartitionManager)Mockito.spy((Object)new SynchronizedPartitionManager((BlockingConsumer)Mockito.mock(BlockingConsumer.class)));
        SpannerStreamingChangeEventSource spannerStreamingChangeEventSource = new SpannerStreamingChangeEventSource(null, null, null, null, (PartitionManager)partitionManager, new SchemaRegistry("Stream Name", new SchemaDao((DatabaseClient)Mockito.mock(DatabaseClient.class)), (Runnable)Mockito.mock(Runnable.class)), null, true, (SpannerOffsetContextFactory)Mockito.mock(SpannerOffsetContextFactory.class));
        spannerStreamingChangeEventSource.commitOffset(Map.of("partitionToken", "v1"), Map.of("offset", Timestamp.now().toString()));
    }

    @Test
    void testCommitRecords() throws InterruptedException {
        SynchronizedPartitionManager partitionManager = new SynchronizedPartitionManager((BlockingConsumer)Mockito.mock(BlockingConsumer.class));
        SpannerStreamingChangeEventSource spannerStreamingChangeEventSource = new SpannerStreamingChangeEventSource(null, null, null, null, (PartitionManager)partitionManager, new SchemaRegistry("Stream Name", new SchemaDao((DatabaseClient)Mockito.mock(DatabaseClient.class)), (Runnable)Mockito.mock(Runnable.class)), null, true, (SpannerOffsetContextFactory)Mockito.mock(SpannerOffsetContextFactory.class));
        SourceRecord sourceRecord1 = (SourceRecord)Mockito.spy((Object)new SourceRecord(Map.of(), Map.of(), "t1", Schema.STRING_SCHEMA, (Object)"v1"));
        SourceRecord sourceRecord2 = (SourceRecord)Mockito.spy((Object)new SourceRecord(Map.of(), Map.of(), "t2", Schema.STRING_SCHEMA, (Object)"v2"));
        Map<String, String> sourcePartition = Map.of("partitionToken", "v1");
        Mockito.when((Object)sourceRecord2.sourcePartition()).thenReturn(sourcePartition);
        Headers headers = (Headers)Mockito.mock(Headers.class);
        Header header = (Header)Mockito.mock(Header.class);
        Mockito.when((Object)header.value()).thenReturn((Object)"header");
        Mockito.when((Object)headers.lastWithName(ArgumentMatchers.anyString())).thenReturn((Object)header);
        Mockito.when((Object)sourceRecord2.headers()).thenReturn((Object)headers);
        spannerStreamingChangeEventSource.commitRecords(List.of(sourceRecord1, sourceRecord2));
        ((SourceRecord)Mockito.verify((Object)sourceRecord1, (VerificationMode)Mockito.times((int)2))).sourcePartition();
        ((SourceRecord)Mockito.verify((Object)sourceRecord1, (VerificationMode)Mockito.times((int)2))).headers();
        ((SourceRecord)Mockito.verify((Object)sourceRecord2, (VerificationMode)Mockito.times((int)2))).sourcePartition();
        ((SourceRecord)Mockito.verify((Object)sourceRecord2, (VerificationMode)Mockito.times((int)2))).headers();
    }
}

