/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.kafka.internal.model;

import com.google.cloud.Timestamp;
import io.debezium.connector.spanner.kafka.internal.model.MessageTypeEnum;
import io.debezium.connector.spanner.kafka.internal.model.TaskState;
import java.util.Map;

public class TaskSyncEvent {
    private final String taskUid;
    private final String consumerId;
    private final long messageTimestamp;
    private final MessageTypeEnum messageType;
    private final long rebalanceGenerationId;
    private final long epochOffset;
    private final Map<String, TaskState> taskStates;

    public static TaskSyncEventBuilder builder() {
        return new TaskSyncEventBuilder();
    }

    public TaskSyncEventBuilder toBuilder() {
        return new TaskSyncEventBuilder().taskUid(this.taskUid).consumerId(this.consumerId).messageTimestamp(this.messageTimestamp).messageType(this.messageType).rebalanceGenerationId(this.rebalanceGenerationId).epochOffset(this.epochOffset).taskStates(this.taskStates);
    }

    public TaskSyncEvent(String taskUid, String consumerId, long messageTimestamp, MessageTypeEnum messageType, long rebalanceGenerationId, long epochOffset, Map<String, TaskState> taskStates) {
        this.taskUid = taskUid;
        this.consumerId = consumerId;
        this.messageTimestamp = messageTimestamp;
        this.messageType = messageType;
        this.rebalanceGenerationId = rebalanceGenerationId;
        this.epochOffset = epochOffset;
        this.taskStates = taskStates;
    }

    public String getTaskUid() {
        return this.taskUid;
    }

    public String getConsumerId() {
        return this.consumerId;
    }

    public long getMessageTimestamp() {
        return this.messageTimestamp;
    }

    public MessageTypeEnum getMessageType() {
        return this.messageType;
    }

    public long getRebalanceGenerationId() {
        return this.rebalanceGenerationId;
    }

    public long getEpochOffset() {
        return this.epochOffset;
    }

    public Map<String, TaskState> getTaskStates() {
        return this.taskStates;
    }

    public String toString() {
        return "TaskSyncEvent(taskUid=" + this.getTaskUid() + ", consumerId=" + this.getConsumerId() + ", messageTimestamp=" + this.getMessageTimestamp() + ", messageType=" + this.getMessageType() + ", rebalanceGenerationId=" + this.getRebalanceGenerationId() + ", epochOffset=" + this.getEpochOffset() + ", taskStates=" + this.getTaskStates() + ")";
    }

    public static class TaskSyncEventBuilder {
        private String taskUid;
        private String consumerId;
        private long messageTimestamp;
        private MessageTypeEnum messageType;
        private long rebalanceGenerationId;
        private long epochOffset;
        private Map<String, TaskState> taskStates;
        private Timestamp databaseSchemaTimestamp;

        TaskSyncEventBuilder() {
        }

        public TaskSyncEventBuilder taskUid(String taskUid) {
            this.taskUid = taskUid;
            return this;
        }

        public TaskSyncEventBuilder consumerId(String consumerId) {
            this.consumerId = consumerId;
            return this;
        }

        public TaskSyncEventBuilder messageTimestamp(long messageTimestamp) {
            this.messageTimestamp = messageTimestamp;
            return this;
        }

        public TaskSyncEventBuilder messageType(MessageTypeEnum messageType) {
            this.messageType = messageType;
            return this;
        }

        public TaskSyncEventBuilder rebalanceGenerationId(long rebalanceGenerationId) {
            this.rebalanceGenerationId = rebalanceGenerationId;
            return this;
        }

        public TaskSyncEventBuilder epochOffset(long epochOffset) {
            this.epochOffset = epochOffset;
            return this;
        }

        public TaskSyncEventBuilder taskStates(Map<String, TaskState> taskStates) {
            this.taskStates = taskStates;
            return this;
        }

        public TaskSyncEventBuilder databaseSchemaTimestamp(Timestamp databaseSchemaTimestamp) {
            this.databaseSchemaTimestamp = databaseSchemaTimestamp;
            return this;
        }

        public TaskSyncEvent build() {
            return new TaskSyncEvent(this.taskUid, this.consumerId, this.messageTimestamp, this.messageType, this.rebalanceGenerationId, this.epochOffset, this.taskStates);
        }

        public String toString() {
            return "TaskSyncEvent.TaskSyncEventBuilder(taskUid=" + this.taskUid + ", consumerId=" + this.consumerId + ", messageTimestamp=" + this.messageTimestamp + ", messageType=" + this.messageType + ", rebalanceGenerationId=" + this.rebalanceGenerationId + ", epochOffset=" + this.epochOffset + ", taskStates=" + this.taskStates + ")";
        }
    }
}

