/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task.operation;

import com.google.cloud.Timestamp;
import io.debezium.connector.spanner.kafka.internal.model.PartitionState;
import io.debezium.connector.spanner.kafka.internal.model.PartitionStateEnum;
import io.debezium.connector.spanner.kafka.internal.model.TaskState;
import io.debezium.connector.spanner.task.TaskSyncContext;
import io.debezium.connector.spanner.task.operation.Operation;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveFinishedPartitionOperation
implements Operation {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoveFinishedPartitionOperation.class);
    private static final Duration DELETION_DELAY = Duration.ofMinutes(60L);
    private boolean isRequiredPublishSyncEvent = false;

    private TaskSyncContext removeFinishedPartitions(TaskSyncContext taskSyncContext) {
        TaskState taskState = taskSyncContext.getCurrentTaskState();
        List<PartitionState> partitions = taskState.getPartitions().stream().map(partitionState -> {
            if (partitionState.getState().equals((Object)PartitionStateEnum.FINISHED) && RemoveFinishedPartitionOperation.allChildrenFinishedAndAtLeastOnePresent(taskSyncContext, partitionState.getToken())) {
                Timestamp currentTime;
                if (partitionState.getFinishedTimestamp() == null) {
                    throw new IllegalStateException("FinishedTimestamp must be specified for finished partitions");
                }
                Timestamp deletionTime = Timestamp.ofTimeSecondsAndNanos((long)(partitionState.getFinishedTimestamp().getSeconds() + DELETION_DELAY.getSeconds()), (int)0);
                if (deletionTime.compareTo(currentTime = Timestamp.now()) < 0) {
                    LOGGER.info("Partition {} will be removed from the task with finished timestamp {}, deletion timestamp {} and current time {}", new Object[]{partitionState, partitionState.getFinishedTimestamp(), deletionTime, currentTime});
                    return null;
                }
                LOGGER.info("Partition {} will not be removed from the task since deletion timestamp {}, finished timestamp {} is less than now {}", new Object[]{deletionTime, partitionState.getFinishedTimestamp(), currentTime});
            }
            return partitionState;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (taskState.getPartitions().size() != partitions.size()) {
            this.isRequiredPublishSyncEvent = true;
        }
        return taskSyncContext.toBuilder().currentTaskState(taskState.toBuilder().partitions(partitions).build()).build();
    }

    private static boolean allChildrenFinishedAndAtLeastOnePresent(TaskSyncContext taskSyncContext, String token) {
        List allPartitionStates = Stream.concat(Stream.concat(taskSyncContext.getTaskStates().values().stream().flatMap(taskState -> taskState.getPartitions().stream()), taskSyncContext.getCurrentTaskState().getPartitions().stream()), Stream.concat(taskSyncContext.getTaskStates().values().stream().flatMap(taskState -> taskState.getSharedPartitions().stream()), taskSyncContext.getCurrentTaskState().getSharedPartitions().stream())).collect(Collectors.toList());
        Set children = allPartitionStates.stream().filter(partitionState -> partitionState.getParents().contains(token)).map(PartitionState::getToken).collect(Collectors.toSet());
        return !children.isEmpty() && children.stream().allMatch(childToken -> allPartitionStates.stream().filter(partitionState -> childToken.equals(partitionState.getToken())).allMatch(partitionState -> PartitionStateEnum.FINISHED.equals((Object)partitionState.getState()) || PartitionStateEnum.REMOVED.equals((Object)partitionState.getState())));
    }

    @Override
    public boolean isRequiredPublishSyncEvent() {
        return this.isRequiredPublishSyncEvent;
    }

    @Override
    public TaskSyncContext doOperation(TaskSyncContext taskSyncContext) {
        return this.removeFinishedPartitions(taskSyncContext);
    }
}

