/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.kafka;

import io.debezium.connector.spanner.SpannerConnectorConfig;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.admin.AdminClient;

public class KafkaAdminClientFactory
implements AutoCloseable {
    private volatile AdminClient adminClient;
    private final SpannerConnectorConfig connectorConfig;

    public KafkaAdminClientFactory(SpannerConnectorConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
    }

    public synchronized AdminClient getAdminClient() {
        if (this.adminClient == null) {
            this.adminClient = this.createAdminClient();
        }
        return this.adminClient;
    }

    private AdminClient createAdminClient() {
        return AdminClient.create((Properties)this.connectorConfig.kafkaProps(Map.of()));
    }

    @Override
    public void close() {
        if (this.adminClient != null) {
            this.adminClient.close();
            this.adminClient = null;
        }
    }
}

