/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.grpc.BaseGrpcServiceException;
import com.google.cloud.spanner.ErrorCode;
import com.google.common.base.Preconditions;
import com.google.protobuf.Duration;
import com.google.protobuf.Message;
import com.google.protobuf.util.Durations;
import com.google.rpc.ResourceInfo;
import com.google.rpc.RetryInfo;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.protobuf.ProtoUtils;
import javax.annotation.Nullable;

public class SpannerException
extends BaseGrpcServiceException {
    private static final long serialVersionUID = 20150916L;
    private static final Metadata.Key<RetryInfo> KEY_RETRY_INFO = ProtoUtils.keyForProto((Message)RetryInfo.getDefaultInstance());
    private final ErrorCode code;

    SpannerException(DoNotConstructDirectly token, ErrorCode code, boolean retryable, @Nullable String message, @Nullable Throwable cause) {
        super(message, cause, code.getCode(), retryable);
        if (token != DoNotConstructDirectly.ALLOWED) {
            throw new AssertionError((Object)"Do not construct directly: use SpannerExceptionFactory");
        }
        this.code = (ErrorCode)((Object)Preconditions.checkNotNull((Object)((Object)code)));
    }

    public ErrorCode getErrorCode() {
        return this.code;
    }

    public long getRetryDelayInMillis() {
        return SpannerException.extractRetryDelay(this.getCause());
    }

    static long extractRetryDelay(Throwable cause) {
        RetryInfo retryInfo;
        Metadata trailers;
        if (cause != null && (trailers = Status.trailersFromThrowable((Throwable)cause)) != null && trailers.containsKey(KEY_RETRY_INFO) && (retryInfo = (RetryInfo)trailers.get(KEY_RETRY_INFO)).hasRetryDelay()) {
            return Durations.toMillis((Duration)retryInfo.getRetryDelay());
        }
        return -1L;
    }

    static enum DoNotConstructDirectly {
        ALLOWED;

    }

    public static abstract class ResourceNotFoundException
    extends SpannerException {
        private final ResourceInfo resourceInfo;

        ResourceNotFoundException(DoNotConstructDirectly token, @Nullable String message, ResourceInfo resourceInfo, @Nullable Throwable cause) {
            super(token, ErrorCode.NOT_FOUND, false, message, cause);
            this.resourceInfo = resourceInfo;
        }

        public String getResourceName() {
            return this.resourceInfo.getResourceName();
        }
    }
}

