/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.ReadWriteTransaction;
import com.google.cloud.spanner.connection.StatementExecutionStep;
import com.google.common.base.Preconditions;

final class RetriableUpdate
implements ReadWriteTransaction.RetriableStatement {
    private final ReadWriteTransaction transaction;
    private final AbstractStatementParser.ParsedStatement statement;
    private final long updateCount;
    private final Options.UpdateOption[] options;

    RetriableUpdate(ReadWriteTransaction transaction, AbstractStatementParser.ParsedStatement statement, long updateCount, Options.UpdateOption ... options) {
        Preconditions.checkNotNull((Object)transaction);
        Preconditions.checkNotNull((Object)statement);
        this.transaction = transaction;
        this.statement = statement;
        this.updateCount = updateCount;
        this.options = options;
    }

    @Override
    public void retry(AbortedException aborted) throws AbortedException {
        long newCount = -1L;
        try {
            this.transaction.getStatementExecutor().invokeInterceptors(this.statement, StatementExecutionStep.RETRY_STATEMENT, this.transaction);
            newCount = this.transaction.getReadContext().executeUpdate(this.statement.getStatement(), this.options);
        }
        catch (AbortedException e) {
            throw e;
        }
        catch (SpannerException e) {
            throw SpannerExceptionFactory.newAbortedDueToConcurrentModificationException(aborted, e);
        }
        if (newCount != this.updateCount) {
            throw SpannerExceptionFactory.newAbortedDueToConcurrentModificationException(aborted);
        }
    }
}

