/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.schema;

import com.google.cloud.spanner.DatabaseClient;
import io.debezium.connector.spanner.db.dao.SchemaDao;
import io.debezium.connector.spanner.db.metadata.SchemaRegistry;
import io.debezium.connector.spanner.db.metadata.TableId;
import io.debezium.connector.spanner.schema.KafkaSpannerSchema;
import io.debezium.connector.spanner.schema.KafkaSpannerTableSchema;
import io.debezium.connector.spanner.schema.KafkaSpannerTableSchemaFactory;
import io.debezium.spi.topic.TopicNamingStrategy;
import io.debezium.util.SchemaNameAdjuster;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Schema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class KafkaSpannerSchemaTest {
    KafkaSpannerSchemaTest() {
    }

    @Test
    void testIsHistorized() {
        SchemaNameAdjuster schemaNameAdjuster = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        SchemaRegistry schemaRegistry = new SchemaRegistry("Stream Name", new SchemaDao(null), (Runnable)Mockito.mock(Runnable.class));
        KafkaSpannerSchema actualKafkaSpannerSchema = new KafkaSpannerSchema(new KafkaSpannerTableSchemaFactory(null, schemaNameAdjuster, schemaRegistry, (Schema)new ConnectSchema(Schema.Type.INT8)));
        actualKafkaSpannerSchema.close();
        Assertions.assertFalse((boolean)actualKafkaSpannerSchema.isHistorized());
    }

    @Test
    void testSchemaFor() {
        SchemaNameAdjuster schemaNameAdjuster = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        SchemaRegistry schemaRegistry = new SchemaRegistry("Stream Name", new SchemaDao(null), (Runnable)Mockito.mock(Runnable.class));
        KafkaSpannerTableSchemaFactory kafkaSpannerTableSchemaFactory = (KafkaSpannerTableSchemaFactory)Mockito.spy((Object)new KafkaSpannerTableSchemaFactory(null, schemaNameAdjuster, schemaRegistry, (Schema)new ConnectSchema(Schema.Type.INT8)));
        KafkaSpannerTableSchema kafkaSpannerTableSchema = (KafkaSpannerTableSchema)Mockito.mock(KafkaSpannerTableSchema.class);
        ((KafkaSpannerTableSchemaFactory)Mockito.doReturn((Object)kafkaSpannerTableSchema).when((Object)kafkaSpannerTableSchemaFactory)).getTableSchema((TableId)ArgumentMatchers.any());
        KafkaSpannerSchema kafkaSpannerSchema = new KafkaSpannerSchema(kafkaSpannerTableSchemaFactory);
        Assertions.assertNotNull((Object)kafkaSpannerSchema.schemaFor(TableId.getTableId((String)"Table Name")));
    }

    @Test
    void testSchemaForThrow() {
        SchemaNameAdjuster schemaNameAdjuster = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        SchemaRegistry schemaRegistry = new SchemaRegistry("Stream Name", new SchemaDao(null), (Runnable)Mockito.mock(Runnable.class));
        KafkaSpannerSchema kafkaSpannerSchema = new KafkaSpannerSchema(new KafkaSpannerTableSchemaFactory(null, schemaNameAdjuster, schemaRegistry, (Schema)new ConnectSchema(Schema.Type.INT8)));
        Assertions.assertThrows(IllegalStateException.class, () -> kafkaSpannerSchema.schemaFor(TableId.getTableId((String)"Table Name")));
    }

    @Test
    void testTableInformationComplete() {
        TopicNamingStrategy topicNamingStrategy = (TopicNamingStrategy)Mockito.mock(TopicNamingStrategy.class);
        SchemaNameAdjuster schemaNameAdjuster = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        SchemaRegistry schemaRegistry = new SchemaRegistry("Stream Name", new SchemaDao((DatabaseClient)Mockito.mock(DatabaseClient.class)), (Runnable)Mockito.mock(Runnable.class));
        Assertions.assertFalse((boolean)new KafkaSpannerSchema(new KafkaSpannerTableSchemaFactory(topicNamingStrategy, schemaNameAdjuster, schemaRegistry, (Schema)new ConnectSchema(Schema.Type.INT8))).tableInformationComplete());
    }
}

