/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.scale.proto;

import io.debezium.connector.spanner.kafka.event.proto.SyncEventProtos;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

class SyncEventProtoMessagesTest {
    SyncEventProtoMessagesTest() {
    }

    @Test
    void checkSyncEventProtobufSerializationWorks() throws IOException {
        SyncEventProtos.TaskState taskStateWithData = SyncEventProtos.TaskState.newBuilder().setTaskUid(UUID.randomUUID().toString()).setConsumerId(UUID.randomUUID().toString()).setStateTimestamp(Instant.now().toEpochMilli()).addPartitions(SyncEventProtos.PartitionState.newBuilder().setToken("test_token1").build()).addSharedPartitions(SyncEventProtos.PartitionState.newBuilder().setToken("test_token2").build()).build();
        SyncEventProtos.TaskState taskStateWithoutData = SyncEventProtos.TaskState.newBuilder().setTaskUid(UUID.randomUUID().toString()).setConsumerId(UUID.randomUUID().toString()).setStateTimestamp(Instant.now().plusSeconds(5000L).toEpochMilli()).build();
        SyncEventProtos.SyncEvent event = SyncEventProtos.SyncEvent.newBuilder().setTaskUid(taskStateWithData.getTaskUid()).setConsumerId(taskStateWithData.getConsumerId()).setMessageTimestamp(taskStateWithData.getStateTimestamp()).addTaskStates(taskStateWithData).addTaskStates(taskStateWithoutData).build();
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();){
            event.writeTo((OutputStream)byteStream);
            SyncEventProtos.SyncEvent deserializedEvent = ((SyncEventProtos.SyncEvent.Builder)SyncEventProtos.SyncEvent.newBuilder().mergeFrom(byteStream.toByteArray())).build();
            Assertions.assertThat((Object)deserializedEvent).isEqualTo((Object)event);
            ((ListAssert)Assertions.assertThat((List)deserializedEvent.getTaskStatesList()).hasSameSizeAs((Iterable)event.getTaskStatesList())).hasSameElementsAs((Iterable)event.getTaskStatesList());
            SyncEventProtos.TaskState deserializedStateWithData = deserializedEvent.getTaskStates(0);
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)deserializedStateWithData.getPartitionsCount());
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)deserializedStateWithData.getSharedPartitionsCount());
            SyncEventProtos.TaskState deserializedStateWithoutData = deserializedEvent.getTaskStates(1);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)deserializedStateWithoutData.getPartitionsCount());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)deserializedStateWithoutData.getSharedPartitionsCount());
        }
    }
}

