/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db.metadata;

import io.debezium.connector.spanner.db.metadata.SchemaMerger;
import io.debezium.connector.spanner.db.metadata.TableId;
import io.debezium.connector.spanner.db.model.schema.Column;
import io.debezium.connector.spanner.db.model.schema.ColumnType;
import io.debezium.connector.spanner.db.model.schema.DataType;
import io.debezium.connector.spanner.db.model.schema.SpannerSchema;
import io.debezium.connector.spanner.db.model.schema.TableSchema;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SchemaMergerTest {
    SchemaMergerTest() {
    }

    @Test
    void mergeAddNewColumn() {
        SpannerSchema schema = this.buildTestSchema(Map.of("test_table", List.of(new Column("id", new ColumnType(DataType.INT64), true, 0L, Boolean.valueOf(false)), new Column("name", new ColumnType(DataType.STRING), false, 1L, Boolean.valueOf(true)))));
        SpannerSchema newSchema = this.buildTestSchema(Map.of("test_table", List.of(new Column("id", new ColumnType(DataType.INT64), true, 0L, Boolean.valueOf(false)), new Column("name", new ColumnType(DataType.STRING), false, 1L, Boolean.valueOf(true)), new Column("belka", new ColumnType(DataType.STRING), false, 2L, Boolean.valueOf(true)))));
        SpannerSchema mergedSchema = SchemaMerger.merge((SpannerSchema)schema, (SpannerSchema)newSchema);
        Assertions.assertNotNull((Object)mergedSchema.getTable(TableId.getTableId((String)"test_table")).getColumn("belka"));
    }

    @Test
    void mergeDeleteColumn() {
        SpannerSchema schema = this.buildTestSchema(Map.of("test_table", List.of(new Column("id", new ColumnType(DataType.INT64), true, 0L, Boolean.valueOf(false)), new Column("name", new ColumnType(DataType.STRING), false, 1L, Boolean.valueOf(true)), new Column("belka", new ColumnType(DataType.STRING), false, 2L, Boolean.valueOf(true)))));
        SpannerSchema newSchema = this.buildTestSchema(Map.of("test_table", List.of(new Column("id", new ColumnType(DataType.INT64), true, 0L, Boolean.valueOf(false)), new Column("name", new ColumnType(DataType.STRING), false, 1L, Boolean.valueOf(true)))));
        SpannerSchema mergedSchema = SchemaMerger.merge((SpannerSchema)schema, (SpannerSchema)newSchema);
        Assertions.assertNotNull((Object)mergedSchema.getTable(TableId.getTableId((String)"test_table")).getColumn("belka"));
    }

    @Test
    void mergeChangeTypeOfColumn() {
        SpannerSchema schema = this.buildTestSchema(Map.of("test_table", List.of(new Column("id", new ColumnType(DataType.INT64), true, 0L, Boolean.valueOf(false)), new Column("name", new ColumnType(DataType.STRING), false, 1L, Boolean.valueOf(true)), new Column("belka", new ColumnType(DataType.BYTES), false, 2L, Boolean.valueOf(true)))));
        SpannerSchema newSchema = this.buildTestSchema(Map.of("test_table", List.of(new Column("id", new ColumnType(DataType.INT64), true, 0L, Boolean.valueOf(false)), new Column("name", new ColumnType(DataType.STRING), false, 1L, Boolean.valueOf(true)), new Column("belka", new ColumnType(DataType.STRING), false, 2L, Boolean.valueOf(true)))));
        SpannerSchema mergedSchema = SchemaMerger.merge((SpannerSchema)schema, (SpannerSchema)newSchema);
        Assertions.assertEquals((Object)DataType.STRING, (Object)mergedSchema.getTable(TableId.getTableId((String)"test_table")).getColumn("belka").getType().getType());
    }

    @Test
    void mergeNewTable() {
        SpannerSchema schema = this.buildTestSchema(Map.of("test_table1", List.of(new Column("id", new ColumnType(DataType.INT64), true, 0L, Boolean.valueOf(false)), new Column("name", new ColumnType(DataType.STRING), false, 1L, Boolean.valueOf(true)))));
        SpannerSchema newSchema = this.buildTestSchema(Map.of("test_table2", List.of(new Column("id", new ColumnType(DataType.INT64), true, 0L, Boolean.valueOf(false)), new Column("test", new ColumnType(DataType.STRING), false, 1L, Boolean.valueOf(true)))));
        SpannerSchema mergedSchema = SchemaMerger.merge((SpannerSchema)schema, (SpannerSchema)newSchema);
        Assertions.assertEquals((int)1, (int)mergedSchema.getAllTables().size());
        Assertions.assertNotNull((Object)mergedSchema.getTable(TableId.getTableId((String)"test_table2")));
    }

    SpannerSchema buildTestSchema(Map<String, List<Column>> definition) {
        Map<TableId, TableSchema> tables = definition.entrySet().stream().map(entry -> {
            TableSchema tableSchema = new TableSchema((String)entry.getKey(), (List)entry.getValue());
            return new AbstractMap.SimpleEntry<TableId, TableSchema>(TableId.getTableId((String)((String)entry.getKey())), tableSchema);
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        return new SpannerSchema(tables);
    }
}

