/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.StructReader;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractStructReader
implements StructReader {
    protected abstract boolean getBooleanInternal(int var1);

    protected abstract long getLongInternal(int var1);

    protected abstract double getDoubleInternal(int var1);

    protected abstract BigDecimal getBigDecimalInternal(int var1);

    protected abstract String getStringInternal(int var1);

    protected String getJsonInternal(int columnIndex) {
        throw new UnsupportedOperationException("Not implemented");
    }

    protected abstract ByteArray getBytesInternal(int var1);

    protected abstract Timestamp getTimestampInternal(int var1);

    protected abstract Date getDateInternal(int var1);

    protected Value getValueInternal(int columnIndex) {
        throw new UnsupportedOperationException("method should be overwritten");
    }

    protected abstract boolean[] getBooleanArrayInternal(int var1);

    protected abstract List<Boolean> getBooleanListInternal(int var1);

    protected abstract long[] getLongArrayInternal(int var1);

    protected abstract List<Long> getLongListInternal(int var1);

    protected abstract double[] getDoubleArrayInternal(int var1);

    protected abstract List<Double> getDoubleListInternal(int var1);

    protected abstract List<BigDecimal> getBigDecimalListInternal(int var1);

    protected abstract List<String> getStringListInternal(int var1);

    protected List<String> getJsonListInternal(int columnIndex) {
        throw new UnsupportedOperationException("Not implemented");
    }

    protected abstract List<ByteArray> getBytesListInternal(int var1);

    protected abstract List<Timestamp> getTimestampListInternal(int var1);

    protected abstract List<Date> getDateListInternal(int var1);

    protected abstract List<Struct> getStructListInternal(int var1);

    @Override
    public int getColumnCount() {
        return this.getType().getStructFields().size();
    }

    @Override
    public Type getColumnType(int columnIndex) {
        return this.getType().getStructFields().get(columnIndex).getType();
    }

    @Override
    public Type getColumnType(String columnName) {
        return this.getType().getStructFields().get(this.getColumnIndex(columnName)).getType();
    }

    @Override
    public boolean isNull(String columnName) {
        return this.isNull(this.getColumnIndex(columnName));
    }

    @Override
    public boolean getBoolean(int columnIndex) {
        this.checkNonNullOfType(columnIndex, Type.bool(), columnIndex);
        return this.getBooleanInternal(columnIndex);
    }

    @Override
    public boolean getBoolean(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, Type.bool(), columnName);
        return this.getBooleanInternal(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) {
        this.checkNonNullOfType(columnIndex, Type.int64(), columnIndex);
        return this.getLongInternal(columnIndex);
    }

    @Override
    public long getLong(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, Type.int64(), columnName);
        return this.getLongInternal(columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) {
        this.checkNonNullOfType(columnIndex, Type.float64(), columnIndex);
        return this.getDoubleInternal(columnIndex);
    }

    @Override
    public double getDouble(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, Type.float64(), columnName);
        return this.getDoubleInternal(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) {
        this.checkNonNullOfType(columnIndex, Type.numeric(), columnIndex);
        return this.getBigDecimalInternal(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, Type.numeric(), columnName);
        return this.getBigDecimalInternal(columnIndex);
    }

    @Override
    public String getString(int columnIndex) {
        this.checkNonNullOfTypes(columnIndex, Arrays.asList(Type.string(), Type.pgNumeric()), columnIndex, "STRING, NUMERIC");
        return this.getStringInternal(columnIndex);
    }

    @Override
    public String getString(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfTypes(columnIndex, Arrays.asList(Type.string(), Type.pgNumeric()), columnName, "STRING, NUMERIC");
        return this.getStringInternal(columnIndex);
    }

    @Override
    public String getJson(int columnIndex) {
        this.checkNonNullOfType(columnIndex, Type.json(), columnIndex);
        return this.getJsonInternal(columnIndex);
    }

    @Override
    public String getJson(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, Type.json(), columnName);
        return this.getJsonInternal(columnIndex);
    }

    @Override
    public ByteArray getBytes(int columnIndex) {
        this.checkNonNullOfType(columnIndex, Type.bytes(), columnIndex);
        return this.getBytesInternal(columnIndex);
    }

    @Override
    public ByteArray getBytes(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, Type.bytes(), columnName);
        return this.getBytesInternal(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) {
        this.checkNonNullOfType(columnIndex, Type.timestamp(), columnIndex);
        return this.getTimestampInternal(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, Type.timestamp(), columnName);
        return this.getTimestampInternal(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex) {
        this.checkNonNullOfType(columnIndex, Type.date(), columnIndex);
        return this.getDateInternal(columnIndex);
    }

    @Override
    public Date getDate(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, Type.date(), columnName);
        return this.getDateInternal(columnIndex);
    }

    @Override
    public Value getValue(int columnIndex) {
        this.checkNonNull(columnIndex, columnIndex);
        return this.getValueInternal(columnIndex);
    }

    @Override
    public Value getValue(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        return this.getValueInternal(columnIndex);
    }

    @Override
    public boolean[] getBooleanArray(int columnIndex) {
        this.checkNonNullOfType(columnIndex, Type.array(Type.bool()), columnIndex);
        return this.getBooleanArrayInternal(columnIndex);
    }

    @Override
    public boolean[] getBooleanArray(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, Type.array(Type.bool()), columnName);
        return this.getBooleanArrayInternal(columnIndex);
    }

    @Override
    public List<Boolean> getBooleanList(int columnIndex) {
        this.checkNonNullOfType(columnIndex, Type.array(Type.bool()), columnIndex);
        return this.getBooleanListInternal(columnIndex);
    }

    @Override
    public List<Boolean> getBooleanList(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, Type.array(Type.bool()), columnName);
        return this.getBooleanListInternal(columnIndex);
    }

    @Override
    public long[] getLongArray(int columnIndex) {
        this.checkNonNullOfType(columnIndex, Type.array(Type.int64()), columnIndex);
        return this.getLongArrayInternal(columnIndex);
    }

    @Override
    public long[] getLongArray(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, Type.array(Type.int64()), columnName);
        return this.getLongArrayInternal(columnIndex);
    }

    @Override
    public List<Long> getLongList(int columnIndex) {
        this.checkNonNullOfType(columnIndex, Type.array(Type.int64()), columnIndex);
        return this.getLongListInternal(columnIndex);
    }

    @Override
    public List<Long> getLongList(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, Type.array(Type.int64()), columnName);
        return this.getLongListInternal(columnIndex);
    }

    @Override
    public double[] getDoubleArray(int columnIndex) {
        this.checkNonNullOfType(columnIndex, Type.array(Type.float64()), columnIndex);
        return this.getDoubleArrayInternal(columnIndex);
    }

    @Override
    public double[] getDoubleArray(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, Type.array(Type.float64()), columnName);
        return this.getDoubleArrayInternal(columnIndex);
    }

    @Override
    public List<Double> getDoubleList(int columnIndex) {
        this.checkNonNullOfType(columnIndex, Type.array(Type.float64()), columnIndex);
        return this.getDoubleListInternal(columnIndex);
    }

    @Override
    public List<Double> getDoubleList(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, Type.array(Type.float64()), columnName);
        return this.getDoubleListInternal(columnIndex);
    }

    @Override
    public List<BigDecimal> getBigDecimalList(int columnIndex) {
        this.checkNonNullOfType(columnIndex, Type.array(Type.numeric()), columnIndex);
        return this.getBigDecimalListInternal(columnIndex);
    }

    @Override
    public List<BigDecimal> getBigDecimalList(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, Type.array(Type.numeric()), columnName);
        return this.getBigDecimalListInternal(columnIndex);
    }

    @Override
    public List<String> getStringList(int columnIndex) {
        this.checkNonNullOfTypes(columnIndex, Arrays.asList(Type.array(Type.string()), Type.array(Type.pgNumeric())), columnIndex, "ARRAY<STRING>, ARRAY<NUMERIC>");
        return this.getStringListInternal(columnIndex);
    }

    @Override
    public List<String> getStringList(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfTypes(columnIndex, Arrays.asList(Type.array(Type.string()), Type.array(Type.pgNumeric())), columnName, "ARRAY<STRING>, ARRAY<NUMERIC>");
        return this.getStringListInternal(columnIndex);
    }

    @Override
    public List<String> getJsonList(int columnIndex) {
        this.checkNonNullOfType(columnIndex, Type.array(Type.json()), columnIndex);
        return this.getJsonListInternal(columnIndex);
    }

    @Override
    public List<String> getJsonList(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, Type.array(Type.json()), columnName);
        return this.getJsonListInternal(columnIndex);
    }

    @Override
    public List<ByteArray> getBytesList(int columnIndex) {
        this.checkNonNullOfType(columnIndex, Type.array(Type.bytes()), columnIndex);
        return this.getBytesListInternal(columnIndex);
    }

    @Override
    public List<ByteArray> getBytesList(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, Type.array(Type.bytes()), columnName);
        return this.getBytesListInternal(columnIndex);
    }

    @Override
    public List<Timestamp> getTimestampList(int columnIndex) {
        this.checkNonNullOfType(columnIndex, Type.array(Type.timestamp()), columnIndex);
        return this.getTimestampListInternal(columnIndex);
    }

    @Override
    public List<Timestamp> getTimestampList(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, Type.array(Type.timestamp()), columnName);
        return this.getTimestampListInternal(columnIndex);
    }

    @Override
    public List<Date> getDateList(int columnIndex) {
        this.checkNonNullOfType(columnIndex, Type.array(Type.date()), columnIndex);
        return this.getDateListInternal(columnIndex);
    }

    @Override
    public List<Date> getDateList(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, Type.array(Type.date()), columnName);
        return this.getDateListInternal(columnIndex);
    }

    @Override
    public List<Struct> getStructList(int columnIndex) {
        this.checkNonNullArrayOfStruct(columnIndex, columnIndex);
        return this.getStructListInternal(columnIndex);
    }

    @Override
    public List<Struct> getStructList(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullArrayOfStruct(columnIndex, columnName);
        return this.getStructListInternal(columnIndex);
    }

    @Override
    public int getColumnIndex(String columnName) {
        return this.getType().getFieldIndex(columnName);
    }

    protected void checkNonNull(int columnIndex, Object columnNameForError) {
        if (this.isNull(columnIndex)) {
            throw new NullPointerException("Column " + columnNameForError + " contains NULL value");
        }
    }

    private void checkNonNullOfType(int columnIndex, Type expectedType, Object columnNameForError) {
        Type actualType = this.getColumnType(columnIndex);
        Preconditions.checkState((boolean)expectedType.equals(actualType), (String)"Column %s is not of correct type: expected %s but was %s", (Object)columnNameForError, (Object)expectedType, (Object)actualType);
        this.checkNonNull(columnIndex, columnNameForError);
    }

    private void checkNonNullOfTypes(int columnIndex, List<Type> expectedTypes, Object columnNameForError, String expectedTypeNames) {
        Type actualType = this.getColumnType(columnIndex);
        Preconditions.checkState((boolean)expectedTypes.contains(actualType), (String)"Column %s is not of correct type: expected one of [%s] but was %s", (Object)columnNameForError, (Object)expectedTypeNames, (Object)actualType);
        this.checkNonNull(columnIndex, columnNameForError);
    }

    private void checkNonNullArrayOfStruct(int columnIndex, Object columnNameForError) {
        Type actualType = this.getColumnType(columnIndex);
        Preconditions.checkState((actualType.getCode() == Type.Code.ARRAY && actualType.getArrayElementType().getCode() == Type.Code.STRUCT ? 1 : 0) != 0, (String)"Column %s is not of correct type: expected ARRAY<STRUCT<...>> but was %s", (Object)columnNameForError, (Object)actualType);
        this.checkNonNull(columnIndex, columnNameForError);
    }
}

