/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db;

import com.google.cloud.spanner.Options;
import io.debezium.connector.spanner.db.DaoFactory;
import io.debezium.connector.spanner.db.dao.ChangeStreamDao;
import io.debezium.connector.spanner.db.mapper.ChangeStreamRecordMapper;
import io.debezium.connector.spanner.db.stream.SpannerChangeStream;
import io.debezium.connector.spanner.db.stream.SpannerChangeStreamService;
import io.debezium.connector.spanner.metrics.MetricsEventPublisher;
import java.time.Duration;
import java.util.UUID;

public class SpannerChangeStreamFactory {
    private static final String JOB_NAME = "SpannerChangeStream_Kafka";
    private final DaoFactory daoFactory;
    private final MetricsEventPublisher metricsEventPublisher;
    private final String connectorName;

    public SpannerChangeStreamFactory(DaoFactory daoFactory, MetricsEventPublisher metricsEventPublisher, String connectorName) {
        this.daoFactory = daoFactory;
        this.metricsEventPublisher = metricsEventPublisher;
        this.connectorName = connectorName;
    }

    public SpannerChangeStream getStream(String changeStreamName, Duration heartbeatMillis, int maxMissedHeartbeats) {
        ChangeStreamDao changeStreamDao = this.daoFactory.getStreamDao(changeStreamName, Options.RpcPriority.MEDIUM, "SpannerChangeStream_Kafka_" + this.connectorName + "_" + UUID.randomUUID());
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        SpannerChangeStreamService streamService = new SpannerChangeStreamService(changeStreamDao, changeStreamRecordMapper, heartbeatMillis, this.metricsEventPublisher);
        return new SpannerChangeStream(streamService, this.metricsEventPublisher, heartbeatMillis, maxMissedHeartbeats);
    }
}

