/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.serialization;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public class UUIDDeserializer
implements Deserializer<UUID> {
    private String encoding = StandardCharsets.UTF_8.name();

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        String propertyName = isKey ? "key.deserializer.encoding" : "value.deserializer.encoding";
        Object encodingValue = configs.get(propertyName);
        if (encodingValue == null) {
            encodingValue = configs.get("deserializer.encoding");
        }
        if (encodingValue instanceof String) {
            this.encoding = (String)encodingValue;
        }
    }

    @Override
    public UUID deserialize(String topic, byte[] data) {
        try {
            if (data == null) {
                return null;
            }
            return UUID.fromString(new String(data, this.encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException("Error when deserializing byte[] to UUID due to unsupported encoding " + this.encoding, e);
        }
        catch (IllegalArgumentException e) {
            throw new SerializationException("Error parsing data into UUID", e);
        }
    }
}

