/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.kafka.internal;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedPublisher<V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BufferedPublisher.class);
    private final Thread thread;
    private final AtomicReference<V> value = new AtomicReference();
    private final Predicate<V> publishImmediately;
    private final Consumer<V> onPublish;
    private final String taskUid;

    public BufferedPublisher(String taskUid, String name, long timeout, Predicate<V> publishImmediately, Consumer<V> onPublish) {
        this.publishImmediately = publishImmediately;
        this.onPublish = onPublish;
        this.taskUid = taskUid;
        this.thread = new Thread(() -> {
            Instant lastUpdatedTime = Instant.now();
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    if (Instant.now().isAfter(lastUpdatedTime.plus(Duration.ofSeconds(600L)))) {
                        LOGGER.info("Task Uid {} is still publishing with AtomicReference value {}", (Object)this.taskUid, (Object)(this.value.get() == null ? 1 : 0));
                        lastUpdatedTime = Instant.now();
                    }
                    this.publishBuffered();
                    Thread.sleep(timeout);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }, "SpannerConnector-" + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buffer(V update) {
        if (this.publishImmediately.test(update)) {
            BufferedPublisher bufferedPublisher = this;
            synchronized (bufferedPublisher) {
                this.value.set(null);
                this.onPublish.accept(update);
            }
        } else {
            this.value.set(update);
        }
    }

    private synchronized void publishBuffered() {
        Object item = this.value.getAndSet(null);
        if (item != null) {
            this.onPublish.accept(item);
        }
    }

    public void start() {
        this.thread.start();
    }

    public void close() {
        this.thread.interrupt();
        while (!this.thread.getState().equals((Object)Thread.State.TERMINATED)) {
        }
    }
}

