/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner;

import io.debezium.connector.spanner.FinishingPartitionManager;
import io.debezium.function.BlockingConsumer;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class FinishingPartitionManagerTest {
    FinishingPartitionManagerTest() {
    }

    @Test
    void commitRecord() throws InterruptedException {
        BlockingConsumer consumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(consumer);
        finishingPartitionManager.registerPartition("testToken");
        finishingPartitionManager.newRecord("testToken", "recordUid1");
        finishingPartitionManager.onPartitionFinishEvent("testToken");
        finishingPartitionManager.commitRecord("testToken", "recordUid1");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept((Object)"testToken");
    }

    @Test
    void onPartitionFinishEvent() throws InterruptedException {
        BlockingConsumer consumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(consumer);
        finishingPartitionManager.registerPartition("testToken");
        finishingPartitionManager.newRecord("testToken", "recordUid1");
        finishingPartitionManager.commitRecord("testToken", "recordUid1");
        finishingPartitionManager.onPartitionFinishEvent("testToken");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept((Object)"testToken");
    }

    @Test
    void forceFinish() throws InterruptedException {
        BlockingConsumer consumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(consumer);
        finishingPartitionManager.registerPartition("testToken");
        finishingPartitionManager.newRecord("testToken", "recordUid1");
        finishingPartitionManager.forceFinish("testToken");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept((Object)"testToken");
    }

    @Test
    void withoutRegistration() throws InterruptedException {
        BlockingConsumer consumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(consumer);
        finishingPartitionManager.newRecord("testToken", "recordUid1");
        finishingPartitionManager.commitRecord("testToken", "recordUid1");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)0))).accept((Object)"testToken");
        finishingPartitionManager.onPartitionFinishEvent("testToken");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)0))).accept((Object)"testToken");
    }

    @Test
    void multipleCommitFinishEventFirst() throws InterruptedException {
        BlockingConsumer consumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(consumer);
        finishingPartitionManager.registerPartition("testToken");
        finishingPartitionManager.newRecord("testToken", "recordUid1");
        finishingPartitionManager.newRecord("testToken", "recordUid2");
        finishingPartitionManager.newRecord("testToken", "recordUid3");
        finishingPartitionManager.commitRecord("testToken", "recordUid1");
        finishingPartitionManager.commitRecord("testToken", "recordUid2");
        finishingPartitionManager.onPartitionFinishEvent("testToken");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)0))).accept((Object)"testToken");
        finishingPartitionManager.commitRecord("testToken", "recordUid3");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept((Object)"testToken");
    }

    @Test
    void multipleCommitCommitFirst1() throws InterruptedException {
        BlockingConsumer consumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(consumer);
        finishingPartitionManager.registerPartition("testToken");
        finishingPartitionManager.newRecord("testToken", "recordUid1");
        finishingPartitionManager.newRecord("testToken", "recordUid2");
        finishingPartitionManager.newRecord("testToken", "recordUid3");
        finishingPartitionManager.commitRecord("testToken", "recordUid1");
        finishingPartitionManager.commitRecord("testToken", "recordUid2");
        finishingPartitionManager.commitRecord("testToken", "recordUid3");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)0))).accept((Object)"testToken");
        finishingPartitionManager.onPartitionFinishEvent("testToken");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept((Object)"testToken");
    }

    @Test
    void multipleCommitCommitFirst2() throws InterruptedException {
        BlockingConsumer consumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(consumer);
        finishingPartitionManager.registerPartition("testToken");
        finishingPartitionManager.newRecord("testToken", "recordUid1");
        finishingPartitionManager.newRecord("testToken", "recordUid2");
        finishingPartitionManager.commitRecord("testToken", "recordUid1");
        finishingPartitionManager.commitRecord("testToken", "recordUid2");
        finishingPartitionManager.newRecord("testToken", "recordUid3");
        finishingPartitionManager.commitRecord("testToken", "recordUid3");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)0))).accept((Object)"testToken");
        finishingPartitionManager.onPartitionFinishEvent("testToken");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept((Object)"testToken");
    }

    @Test
    void multipleCommitNoEvents() throws InterruptedException {
        BlockingConsumer consumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(consumer);
        finishingPartitionManager.registerPartition("testToken");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)0))).accept((Object)"testToken");
        finishingPartitionManager.onPartitionFinishEvent("testToken");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept((Object)"testToken");
    }

    @Test
    void multipleCommitNoEventsWithWrongCommitCall() throws InterruptedException {
        BlockingConsumer consumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(consumer);
        finishingPartitionManager.registerPartition("testToken");
        finishingPartitionManager.commitRecord("testToken", "recordUid3");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)0))).accept((Object)"testToken");
        finishingPartitionManager.onPartitionFinishEvent("testToken");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept((Object)"testToken");
    }

    @Test
    void multipleCommitNoEventsWithWrongCommitCallOnly() throws InterruptedException {
        BlockingConsumer consumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(consumer);
        finishingPartitionManager.registerPartition("testToken");
        finishingPartitionManager.commitRecord("testToken", "recordUid3");
        ((BlockingConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)0))).accept((Object)"testToken");
    }
}

