/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task;

import com.google.cloud.Timestamp;
import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.connector.spanner.SpannerErrorHandler;
import io.debezium.connector.spanner.kafka.internal.model.PartitionState;
import io.debezium.connector.spanner.kafka.internal.model.PartitionStateEnum;
import io.debezium.connector.spanner.task.PartitionOffsetProvider;
import io.debezium.connector.spanner.task.TaskSyncContext;
import io.debezium.connector.spanner.task.TaskSyncContextHolder;
import java.util.AbstractMap;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowWatermarkCalculator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LowWatermarkCalculator.class);
    private static final long OFFSET_MONITORING_LAG_MAX_MS = 60000L;
    private final TaskSyncContextHolder taskSyncContextHolder;
    private final SpannerConnectorConfig spannerConnectorConfig;
    private final PartitionOffsetProvider partitionOffsetProvider;

    public LowWatermarkCalculator(SpannerConnectorConfig spannerConnectorConfig, TaskSyncContextHolder taskSyncContextHolder, PartitionOffsetProvider partitionOffsetProvider) {
        this.taskSyncContextHolder = taskSyncContextHolder;
        this.spannerConnectorConfig = spannerConnectorConfig;
        this.partitionOffsetProvider = partitionOffsetProvider;
    }

    public Timestamp calculateLowWatermark() {
        Map<String, Timestamp> offsets;
        TaskSyncContext taskSyncContext = this.taskSyncContextHolder.get();
        if (!taskSyncContext.isInitialized()) {
            return null;
        }
        Map<String, List<PartitionState>> partitionsMap = taskSyncContext.getAllTaskStates().values().stream().flatMap(taskState -> taskState.getPartitions().stream()).filter(partitionState -> !partitionState.getState().equals((Object)PartitionStateEnum.FINISHED) && !partitionState.getState().equals((Object)PartitionStateEnum.REMOVED)).collect(Collectors.groupingBy(PartitionState::getToken));
        Set<String> duplicatesInPartitions = this.checkDuplication(partitionsMap);
        if (!duplicatesInPartitions.isEmpty()) {
            LOGGER.warn("calculateLowWatermark: found duplication in partitionsMap: {}", duplicatesInPartitions);
            return null;
        }
        Map<String, PartitionState> partitions = partitionsMap.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<String, PartitionState>((String)entry.getKey(), (PartitionState)((List)entry.getValue()).get(0))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, List<PartitionState>> sharedPartitionsMap = taskSyncContext.getAllTaskStates().values().stream().flatMap(taskState -> taskState.getSharedPartitions().stream()).filter(partitionState -> !partitions.containsKey(partitionState.getToken())).collect(Collectors.groupingBy(PartitionState::getToken));
        Set<String> duplicatesInSharedPartitions = this.checkDuplication(sharedPartitionsMap);
        if (!duplicatesInSharedPartitions.isEmpty()) {
            LOGGER.warn("calculateLowWatermark: found duplication in sharedPartitionsMap: {}", duplicatesInSharedPartitions);
            return null;
        }
        Map<String, PartitionState> sharedPartitions = sharedPartitionsMap.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<String, PartitionState>((String)entry.getKey(), (PartitionState)((List)entry.getValue()).get(0))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        HashMap<String, PartitionState> allPartitions = new HashMap<String, PartitionState>();
        allPartitions.putAll(partitions);
        allPartitions.putAll(sharedPartitions);
        if (allPartitions.containsKey("Parent0")) {
            long now = new Date().getTime();
            long lag = now - ((PartitionState)allPartitions.get("Parent0")).getStartTimestamp().toDate().getTime();
            if (lag > 60000L) {
                LOGGER.warn("Partition has a very old start timestamp, lag: {}, token: {}", (Object)lag, (Object)"Parent0");
            }
            return ((PartitionState)allPartitions.get("Parent0")).getStartTimestamp();
        }
        try {
            offsets = this.partitionOffsetProvider.getOffsets(allPartitions.keySet());
        }
        catch (ConnectException e) {
            if (e.getCause() != null && e.getCause() instanceof InterruptedException) {
                LOGGER.info("Kafka connect offsetStorageReader is interrupting... Thread interrupted: {}", (Object)Thread.currentThread().isInterrupted());
            } else {
                LOGGER.warn("Kafka connect offsetStorageReader cannot return offsets. Thread interrupted: {}. {}", (Object)Thread.currentThread().isInterrupted(), (Object)SpannerErrorHandler.getStackTrace(e));
            }
            return null;
        }
        catch (RuntimeException e) {
            LOGGER.warn("Kafka connect offsetStorageReader cannot return offsets {}", (Object)SpannerErrorHandler.getStackTrace(e));
            return null;
        }
        this.monitorOffsets(offsets);
        return allPartitions.values().stream().map(partitionState -> {
            Timestamp timestamp = (Timestamp)offsets.get(partitionState.getToken());
            if (timestamp != null) {
                return timestamp;
            }
            if (partitionState.getStartTimestamp() != null) {
                return partitionState.getStartTimestamp();
            }
            throw new IllegalStateException("lastCommitTimestamp or startTimestamp are not specified or offsets are empty");
        }).min(Timestamp::compareTo).orElse(this.spannerConnectorConfig.startTime());
    }

    private void monitorOffsets(Map<String, Timestamp> offsets) {
        if (offsets == null) {
            return;
        }
        long now = new Date().getTime();
        offsets.entrySet().forEach(e -> {
            Timestamp timestamp = (Timestamp)e.getValue();
            if (timestamp != null) {
                String token = (String)e.getKey();
                long lag = now - timestamp.toDate().getTime();
                if (lag > 60000L) {
                    LOGGER.warn("Partition has a very old offset, lag: {}, token: {}", (Object)lag, (Object)token);
                }
            }
        });
    }

    private Set<String> checkDuplication(Map<String, List<PartitionState>> map) {
        return map.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.toUnmodifiableSet());
    }
}

