/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task.operation;

import io.debezium.connector.spanner.db.model.Partition;
import io.debezium.connector.spanner.kafka.internal.model.PartitionState;
import io.debezium.connector.spanner.kafka.internal.model.PartitionStateEnum;
import io.debezium.connector.spanner.kafka.internal.model.TaskState;
import io.debezium.connector.spanner.task.TaskSyncContext;
import io.debezium.connector.spanner.task.operation.Operation;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildPartitionOperation
implements Operation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChildPartitionOperation.class);
    private final List<Partition> newPartitions;

    public ChildPartitionOperation(List<Partition> newPartitions) {
        this.newPartitions = newPartitions;
    }

    private TaskSyncContext share(TaskSyncContext taskSyncContext) {
        for (Partition newPartition : this.newPartitions) {
            TaskState taskState = taskSyncContext.getCurrentTaskState();
            ArrayList<PartitionState> partitions = new ArrayList<PartitionState>(taskState.getPartitions());
            ArrayList<PartitionState> sharedPartitions = new ArrayList<PartitionState>(taskState.getSharedPartitions());
            if (this.existPartition(taskSyncContext, newPartition.getToken())) {
                LOGGER.warn("Partition {} already exists in tasks context", (Object)newPartition.getToken());
                continue;
            }
            String taskUid = this.findCandidateToSharePartition(taskSyncContext);
            LOGGER.info("Task {} : share partition {} to {}", new Object[]{taskSyncContext.getTaskUid(), newPartition.getToken(), taskUid});
            PartitionState partitionState = PartitionState.builder().token(newPartition.getToken()).startTimestamp(newPartition.getStartTimestamp()).endTimestamp(newPartition.getEndTimestamp()).assigneeTaskUid(taskUid).state(PartitionStateEnum.CREATED).parents(newPartition.getParentTokens()).build();
            if (taskSyncContext.getTaskUid().equals(taskUid)) {
                partitions.add(partitionState);
                LOGGER.debug("ChildPartitionOperation: added new partition: {}", (Object)newPartition.getToken());
            } else {
                sharedPartitions.add(partitionState);
                LOGGER.debug("ChildPartitionOperation: shared new partition: {}", (Object)newPartition.getToken());
            }
            taskSyncContext = taskSyncContext.toBuilder().currentTaskState(taskState.toBuilder().partitions(partitions).sharedPartitions(sharedPartitions).build()).build();
        }
        return taskSyncContext;
    }

    private boolean existPartition(TaskSyncContext taskSyncContext, String token) {
        HashSet tokens = new HashSet();
        tokens.addAll(taskSyncContext.getCurrentTaskState().getPartitions().stream().map(PartitionState::getToken).collect(Collectors.toSet()));
        tokens.addAll(taskSyncContext.getCurrentTaskState().getSharedPartitions().stream().map(PartitionState::getToken).collect(Collectors.toSet()));
        tokens.addAll(taskSyncContext.getTaskStates().values().stream().flatMap(taskState -> taskState.getPartitions().stream()).map(PartitionState::getToken).collect(Collectors.toSet()));
        tokens.addAll(taskSyncContext.getTaskStates().values().stream().flatMap(taskState -> taskState.getSharedPartitions().stream()).map(PartitionState::getToken).collect(Collectors.toSet()));
        return tokens.contains(token);
    }

    private String findCandidateToSharePartition(TaskSyncContext taskSyncContext) {
        String currentTaskUid = taskSyncContext.getTaskUid();
        Collection<TaskState> taskStates = taskSyncContext.getAllTaskStates().values();
        Map<String, Integer> candidateMap = taskStates.stream().map(taskState -> {
            Set tokens = taskState.getPartitions().stream().filter(partitionState -> !PartitionStateEnum.FINISHED.equals((Object)partitionState.getState()) && !PartitionStateEnum.REMOVED.equals((Object)partitionState.getState())).map(PartitionState::getToken).collect(Collectors.toCollection(HashSet::new));
            Set assignedTokens = taskStates.stream().flatMap(taskState1 -> taskState1.getSharedPartitions().stream()).filter(partitionState -> partitionState.getAssigneeTaskUid().equals(taskState.getTaskUid())).map(PartitionState::getToken).collect(Collectors.toSet());
            tokens.addAll(assignedTokens);
            return new AbstractMap.SimpleEntry<String, Integer>(taskState.getTaskUid(), tokens.size());
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        Optional<Integer> minPartitionsValue = candidateMap.values().stream().min(Integer::compare);
        if (minPartitionsValue.isEmpty() || minPartitionsValue.get().equals(candidateMap.get(currentTaskUid))) {
            return currentTaskUid;
        }
        List finalCandidateList = candidateMap.entrySet().stream().filter(entry -> ((Integer)entry.getValue()).equals(minPartitionsValue.get())).map(Map.Entry::getKey).collect(Collectors.toList());
        int index = new Random().nextInt(finalCandidateList.size());
        return (String)finalCandidateList.get(index);
    }

    @Override
    public boolean isRequiredPublishSyncEvent() {
        return true;
    }

    @Override
    public TaskSyncContext doOperation(TaskSyncContext taskSyncContext) {
        return this.share(taskSyncContext);
    }
}

