/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.kafka.internal.model;

import com.google.cloud.Timestamp;
import io.debezium.connector.spanner.kafka.internal.model.PartitionStateEnum;
import java.util.Objects;
import java.util.Set;

public class PartitionState
implements Comparable<PartitionState> {
    private final String token;
    private final Timestamp startTimestamp;
    private final Timestamp endTimestamp;
    private final PartitionStateEnum state;
    private final Set<String> parents;
    private final String assigneeTaskUid;
    private final Timestamp finishedTimestamp;

    public PartitionState(String token, Timestamp startTimestamp, Timestamp endTimestamp, PartitionStateEnum state, Set<String> parents, String assigneeTaskUid, Timestamp finishedTimestamp) {
        this.token = token;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.state = state;
        this.parents = parents;
        this.assigneeTaskUid = assigneeTaskUid;
        this.finishedTimestamp = finishedTimestamp;
    }

    public static PartitionStateBuilder builder() {
        return new PartitionStateBuilder();
    }

    public PartitionStateBuilder toBuilder() {
        return new PartitionStateBuilder().token(this.token).startTimestamp(this.startTimestamp).endTimestamp(this.endTimestamp).state(this.state).parents(this.parents).assigneeTaskUid(this.assigneeTaskUid).finishedTimestamp(this.finishedTimestamp);
    }

    public String getToken() {
        return this.token;
    }

    public Timestamp getStartTimestamp() {
        return this.startTimestamp;
    }

    public Timestamp getEndTimestamp() {
        return this.endTimestamp;
    }

    public PartitionStateEnum getState() {
        return this.state;
    }

    public Set<String> getParents() {
        return this.parents;
    }

    public String getAssigneeTaskUid() {
        return this.assigneeTaskUid;
    }

    public Timestamp getFinishedTimestamp() {
        return this.finishedTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionState that = (PartitionState)o;
        return Objects.equals(this.token, that.token);
    }

    public int hashCode() {
        return Objects.hash(this.token);
    }

    @Override
    public int compareTo(PartitionState partitionState) {
        if (!Objects.equals(partitionState.getToken(), this.token)) {
            return this.token.compareTo(partitionState.getToken());
        }
        return this.state.compareTo(partitionState.state);
    }

    public String toString() {
        return "PartitionState{token='" + this.token + "', startTimestamp=" + this.startTimestamp + ", endTimestamp=" + this.endTimestamp + ", state=" + this.state + ", parents=" + this.parents + ", assigneeTaskUid='" + this.assigneeTaskUid + "', finishedTimestamp=" + this.finishedTimestamp + "}";
    }

    public static class PartitionStateBuilder {
        private String token;
        private Timestamp startTimestamp;
        private Timestamp endTimestamp;
        private PartitionStateEnum state;
        private Set<String> parents;
        private String assigneeTaskUid;
        private Timestamp finishedTimestamp;

        PartitionStateBuilder() {
        }

        public PartitionStateBuilder token(String token) {
            this.token = token;
            return this;
        }

        public PartitionStateBuilder startTimestamp(Timestamp startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public PartitionStateBuilder endTimestamp(Timestamp endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public PartitionStateBuilder state(PartitionStateEnum state) {
            this.state = state;
            return this;
        }

        public PartitionStateBuilder parents(Set<String> parents) {
            this.parents = parents;
            return this;
        }

        public PartitionStateBuilder assigneeTaskUid(String assigneeTaskUid) {
            this.assigneeTaskUid = assigneeTaskUid;
            return this;
        }

        public PartitionStateBuilder finishedTimestamp(Timestamp finishedTime) {
            this.finishedTimestamp = finishedTime;
            return this;
        }

        public PartitionState build() {
            return new PartitionState(this.token, this.startTimestamp, this.endTimestamp, this.state, this.parents, this.assigneeTaskUid, this.finishedTimestamp);
        }
    }
}

