/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.kafka.internal;

import io.debezium.connector.spanner.SpannerConnectorTask;
import io.debezium.connector.spanner.exception.SpannerConnectorException;
import io.debezium.connector.spanner.kafka.internal.RebalancingConsumerFactory;
import io.debezium.connector.spanner.kafka.internal.model.RebalanceEventMetadata;
import io.debezium.connector.spanner.task.utils.ResettableDelayedAction;
import io.debezium.function.BlockingConsumer;
import java.time.Duration;
import java.util.Collection;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InterruptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RebalancingEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RebalancingEventListener.class);
    private final String consumerGroup;
    private final String topic;
    private final Duration pollDuration;
    private final Duration commitOffsetsTimeout;
    private final RebalancingConsumerFactory<?, ?> consumerFactory;
    private final java.util.function.Consumer<RuntimeException> errorHandler;
    private volatile Consumer<?, ?> consumer;
    private volatile Thread thread;
    private volatile BlockingConsumer<RebalanceEventMetadata> rebalancingAction;
    private final ResettableDelayedAction resettableDelayedAction;
    private volatile RebalanceEventMetadata lastRebalanceEventMetadata;
    private final SpannerConnectorTask task;

    public RebalancingEventListener(SpannerConnectorTask task, String consumerGroup, String topic, Duration rebalancingTaskWaitingTimeout, RebalancingConsumerFactory<?, ?> consumerFactory, java.util.function.Consumer<RuntimeException> errorHandler) {
        this.task = task;
        this.consumerGroup = consumerGroup;
        this.topic = topic;
        this.pollDuration = Duration.ofMillis(consumerFactory.getConfig().rebalancingPollDuration());
        this.commitOffsetsTimeout = Duration.ofMillis(consumerFactory.getConfig().rebalancingCommitOffsetsTimeout());
        this.consumerFactory = consumerFactory;
        this.errorHandler = errorHandler;
        this.resettableDelayedAction = new ResettableDelayedAction("rebalance-delayed-action", rebalancingTaskWaitingTimeout);
    }

    public void listen(BlockingConsumer<RebalanceEventMetadata> action) {
        this.rebalancingAction = action;
        this.consumer = this.consumerFactory.createSubscribeConsumer(this.consumerGroup, this.topic, new ConsumerRebalanceListener(){

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                LOGGER.info("Task {} - Rebalance happened", (Object)RebalancingEventListener.this.task.getTaskUid());
                ConsumerGroupMetadata meta = RebalancingEventListener.this.consumer.groupMetadata();
                RebalancingEventListener.this.lastRebalanceEventMetadata = new RebalanceEventMetadata(meta.memberId(), meta.generationId(), RebalancingEventListener.this.isLeader(partitions));
                LOGGER.info("Task {} - Rebalance: Waiting for other tasks to connect", (Object)RebalancingEventListener.this.task.getTaskUid());
                RebalancingEventListener.this.resettableDelayedAction.set(() -> {
                    LOGGER.info("Task {} -Rebalance finished", (Object)RebalancingEventListener.this.task.getTaskUid());
                    try {
                        RebalancingEventListener.this.rebalancingAction.accept((Object)RebalancingEventListener.this.lastRebalanceEventMetadata);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                });
            }

            public void onPartitionsLost(Collection<TopicPartition> partitions) {
            }
        });
        this.thread = new Thread(() -> {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        this.consumer.poll(this.pollDuration);
                        this.consumer.commitSync(this.commitOffsetsTimeout);
                    }
                    catch (InterruptException e) {
                        try {
                            this.consumer.unsubscribe();
                            this.consumer.close();
                            return;
                        }
                        catch (InterruptException interruptException) {
                            // empty catch block
                        }
                        return;
                    }
                }
            }
            finally {
                try {
                    this.consumer.unsubscribe();
                    this.consumer.close();
                }
                catch (InterruptException interruptException) {}
            }
        }, "SpannerConnector-RebalancingEventListener");
        this.thread.setUncaughtExceptionHandler((t, ex) -> this.errorHandler.accept(new SpannerConnectorException("Error during poll from the Rebalance Topic", ex)));
        this.thread.start();
    }

    private boolean isLeader(Collection<TopicPartition> partitions) {
        return partitions.stream().anyMatch(x -> x.partition() == 0);
    }

    public void shutdown() {
        this.resettableDelayedAction.clear();
        if (this.thread == null) {
            return;
        }
        this.thread.interrupt();
        while (!this.thread.getState().equals((Object)Thread.State.TERMINATED)) {
        }
        this.thread = null;
    }
}

