/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner;

import io.debezium.connector.spanner.FinishingPartitionManager;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinishPartitionWatchDog {
    private static final Logger LOGGER = LoggerFactory.getLogger(FinishPartitionWatchDog.class);
    private final Thread thread;
    private final Map<String, Instant> partition = new HashMap<String, Instant>();

    public FinishPartitionWatchDog(FinishingPartitionManager finishingPartitionManager, Duration timeout, Consumer<List<String>> errorHandler) {
        this.thread = new Thread(() -> {
            while (true) {
                Set<String> pendingToFinish = finishingPartitionManager.getPendingFinishPartitions();
                pendingToFinish.forEach(token -> this.partition.computeIfAbsent((String)token, token1 -> Instant.now()));
                this.partition.keySet().stream().filter(token -> !pendingToFinish.contains(token)).forEach(this.partition::remove);
                ArrayList tokens = new ArrayList();
                this.partition.forEach((token, instant) -> {
                    if (instant.isAfter(instant.plus(timeout))) {
                        tokens.add(token);
                    }
                });
                if (!tokens.isEmpty()) {
                    LOGGER.warn("Partitions awaiting finish : {}, timeout: {}", tokens, (Object)timeout);
                    errorHandler.accept(tokens);
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }, "SpannerConnector-FinishingPartitionWatchDog");
    }

    public void stop() {
        this.thread.interrupt();
    }
}

