/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task.operation;

import com.google.cloud.Timestamp;
import io.debezium.connector.spanner.db.model.Partition;
import io.debezium.connector.spanner.kafka.internal.model.PartitionState;
import io.debezium.connector.spanner.kafka.internal.model.PartitionStateEnum;
import io.debezium.connector.spanner.kafka.internal.model.TaskState;
import io.debezium.connector.spanner.task.TaskSyncContext;
import io.debezium.connector.spanner.task.operation.ChildPartitionOperation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ChildPartitionOperationTest {
    ChildPartitionOperationTest() {
    }

    @Test
    void doOperation() {
        TaskSyncContext taskSyncContext = new ChildPartitionOperation(List.of(this.buildPartition("n1"), this.buildPartition("n2"))).doOperation(this.buildTaskSyncContext());
        Assertions.assertEquals((int)3, (int)taskSyncContext.getCurrentTaskState().getPartitions().size());
        Assertions.assertEquals((int)2, (int)taskSyncContext.getCurrentTaskState().getSharedPartitions().size());
        taskSyncContext = new ChildPartitionOperation(List.of(this.buildPartition("n3"), this.buildPartition("n4"))).doOperation(taskSyncContext);
        Assertions.assertEquals((int)3, (int)taskSyncContext.getCurrentTaskState().getPartitions().size());
        Assertions.assertEquals((int)4, (int)taskSyncContext.getCurrentTaskState().getSharedPartitions().size());
        taskSyncContext = new ChildPartitionOperation(List.of(this.buildPartition("n5"))).doOperation(taskSyncContext);
        Assertions.assertEquals((int)4, (int)taskSyncContext.getCurrentTaskState().getPartitions().size());
        Assertions.assertEquals((int)4, (int)taskSyncContext.getCurrentTaskState().getSharedPartitions().size());
    }

    private TaskSyncContext buildTaskSyncContext() {
        return TaskSyncContext.builder().taskUid("taskO").currentTaskState(TaskState.builder().taskUid("taskO").partitions(List.of(PartitionState.builder().token("t1").state(PartitionStateEnum.RUNNING).build(), PartitionState.builder().token("t2").state(PartitionStateEnum.RUNNING).build(), PartitionState.builder().token("t3").state(PartitionStateEnum.RUNNING).build())).sharedPartitions(List.of()).build()).taskStates(Map.of("task1", TaskState.builder().taskUid("task1").partitions(List.of(PartitionState.builder().token("t6").state(PartitionStateEnum.RUNNING).build())).sharedPartitions(List.of()).build(), "task2", TaskState.builder().taskUid("task2").partitions(List.of(PartitionState.builder().token("t7").state(PartitionStateEnum.RUNNING).build())).sharedPartitions(List.of()).build())).build();
    }

    private Partition buildPartition(String token) {
        return Partition.builder().token(token).parentTokens(Set.of()).startTimestamp(Timestamp.now()).endTimestamp(null).build();
    }
}

