/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.metrics.latency;

import io.debezium.connector.spanner.metrics.latency.LatencyCalculator;
import java.util.HashMap;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.source.SourceRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class LatencyCalculatorTest {
    LatencyCalculatorTest() {
    }

    @Test
    void testGetTotalLatency() {
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        Assertions.assertNull((Object)LatencyCalculator.getTotalLatency((SourceRecord)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value")));
    }

    @Test
    void testGetReadToEmitLatency() {
        Assertions.assertNull((Object)LatencyCalculator.getReadToEmitLatency((SourceRecord)new SourceRecord(new HashMap(), new HashMap(), "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value")));
    }

    @Test
    void testGetSpannerLatency() {
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        Assertions.assertNull((Object)LatencyCalculator.getSpannerLatency((SourceRecord)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value")));
    }

    @Test
    void testGetCommitToEmitLatency() {
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        Assertions.assertNull((Object)LatencyCalculator.getCommitToEmitLatency((SourceRecord)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value")));
    }

    @Test
    void testGetCommitToPublishLatency() {
        SourceRecord sourceRecord = (SourceRecord)Mockito.spy((Object)new SourceRecord(new HashMap(), new HashMap(), "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value"));
        Headers headers = (Headers)Mockito.mock(Headers.class);
        Header header = (Header)Mockito.mock(Header.class);
        Mockito.when((Object)header.value()).thenReturn(null);
        Mockito.when((Object)headers.lastWithName(ArgumentMatchers.anyString())).thenReturn((Object)header);
        Mockito.when((Object)sourceRecord.headers()).thenReturn((Object)headers);
        Long commitToPublishLatency = LatencyCalculator.getCommitToPublishLatency((SourceRecord)sourceRecord);
        Assertions.assertNull((Object)commitToPublishLatency);
    }

    @Test
    void testGetEmitToPublishLatency() {
        SourceRecord sourceRecord = (SourceRecord)Mockito.spy((Object)new SourceRecord(new HashMap(), new HashMap(), "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value"));
        Headers headers = (Headers)Mockito.mock(Headers.class);
        Header header = (Header)Mockito.mock(Header.class);
        Mockito.when((Object)header.value()).thenReturn(null);
        Mockito.when((Object)headers.lastWithName(ArgumentMatchers.anyString())).thenReturn((Object)header);
        Mockito.when((Object)sourceRecord.headers()).thenReturn((Object)headers);
        Long emitToPublishLatency = LatencyCalculator.getEmitToPublishLatency((SourceRecord)sourceRecord);
        Assertions.assertNull((Object)emitToPublishLatency);
    }

    @Test
    void testGetOwnConnectorLatency() {
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        Assertions.assertNull((Object)LatencyCalculator.getOwnConnectorLatency((SourceRecord)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value")));
    }

    @Test
    void testGetLowWatermarkLag() {
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        Assertions.assertNull((Object)LatencyCalculator.getLowWatermarkLag((SourceRecord)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value")));
    }
}

