/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.metrics;

import io.debezium.connector.spanner.metrics.MetricsEventPublisher;
import io.debezium.connector.spanner.metrics.event.MetricEvent;
import io.debezium.connector.spanner.metrics.event.NewQueueMetricEvent;
import java.util.HashMap;
import java.util.function.Consumer;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.source.SourceRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class MetricsEventPublisherTest {
    MetricsEventPublisherTest() {
    }

    @Test
    void testPublishMetricEvent() {
        MetricsEventPublisher metricsEventPublisher = (MetricsEventPublisher)Mockito.spy((Object)new MetricsEventPublisher());
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        metricsEventPublisher.subscribe(NewQueueMetricEvent.class, consumer);
        metricsEventPublisher.publishMetricEvent((MetricEvent)new NewQueueMetricEvent());
        ((Consumer)Mockito.verify((Object)consumer)).accept((NewQueueMetricEvent)ArgumentMatchers.any());
    }

    @Test
    void testSubscribe() {
        MetricsEventPublisher metricsEventPublisher = (MetricsEventPublisher)Mockito.spy((Object)new MetricsEventPublisher());
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        metricsEventPublisher.subscribe(NewQueueMetricEvent.class, consumer);
        Assertions.assertThrows(IllegalStateException.class, () -> metricsEventPublisher.subscribe(NewQueueMetricEvent.class, consumer));
    }

    @Test
    void testLogLatency() {
        MetricsEventPublisher metricsEventPublisher = (MetricsEventPublisher)Mockito.spy((Object)new MetricsEventPublisher());
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        SourceRecord sourceRecord = new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value");
        metricsEventPublisher.logLatency(sourceRecord);
        ((MetricsEventPublisher)Mockito.verify((Object)metricsEventPublisher, (VerificationMode)Mockito.times((int)0))).publishMetricEvent((MetricEvent)ArgumentMatchers.any());
    }

    @Test
    void testLogLatencySourceRecordNull() {
        MetricsEventPublisher metricsEventPublisher = (MetricsEventPublisher)Mockito.spy((Object)new MetricsEventPublisher());
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        SourceRecord sourceRecord = new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value");
        metricsEventPublisher.logLatency(sourceRecord);
        ((MetricsEventPublisher)Mockito.verify((Object)metricsEventPublisher, (VerificationMode)Mockito.times((int)0))).publishMetricEvent((MetricEvent)ArgumentMatchers.any());
    }

    @Test
    void testLogLatencySourceRecord() {
        MetricsEventPublisher metricsEventPublisher = (MetricsEventPublisher)Mockito.spy((Object)new MetricsEventPublisher());
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        ConnectSchema schema = new ConnectSchema(Schema.Type.INT8);
        SourceRecord sourceRecord = (SourceRecord)Mockito.spy((Object)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)schema, (Object)"Value"));
        Headers headers = (Headers)Mockito.mock(Headers.class);
        ((SourceRecord)Mockito.doReturn((Object)headers).when((Object)sourceRecord)).headers();
        metricsEventPublisher.logLatency(sourceRecord);
        ((MetricsEventPublisher)Mockito.verify((Object)metricsEventPublisher, (VerificationMode)Mockito.times((int)0))).publishMetricEvent((MetricEvent)ArgumentMatchers.any());
    }

    @Test
    void testNotLogLatency() {
        MetricsEventPublisher metricsEventPublisher = (MetricsEventPublisher)Mockito.spy((Object)new MetricsEventPublisher());
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        SourceRecord sourceRecord = (SourceRecord)Mockito.spy((Object)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value"));
        Headers headers = (Headers)Mockito.mock(Headers.class);
        Mockito.when((Object)sourceRecord.headers()).thenReturn((Object)headers);
        Mockito.when((Object)headers.lastWithName(ArgumentMatchers.anyString())).thenReturn(null);
        metricsEventPublisher.logLatency(sourceRecord);
        ((MetricsEventPublisher)Mockito.verify((Object)metricsEventPublisher, (VerificationMode)Mockito.times((int)0))).publishMetricEvent((MetricEvent)ArgumentMatchers.any());
    }
}

