/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.kafka.internal;

import com.google.common.collect.Ordering;
import io.debezium.connector.spanner.kafka.internal.BufferedPublisher;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

class BufferedPublisherTest {
    BufferedPublisherTest() {
    }

    @Test
    void testBufferedPublisher_1() throws InterruptedException {
        Predicate<Integer> publishImmediately = p -> p % 10 == 0;
        Consumer<Integer> onPublish = v -> {};
        this.runAndCheck(publishImmediately, onPublish);
    }

    @Test
    void testBufferedPublisher_2() throws InterruptedException {
        Predicate<Integer> publishImmediately = p -> p % 10 == 0;
        Consumer<Integer> onPublish = v -> {};
        this.runAndCheck(publishImmediately, onPublish);
    }

    @Test
    void testBufferedPublisher_3() throws InterruptedException {
        Predicate<Integer> publishImmediately = p -> p % 100 == 0;
        Consumer<Integer> onPublish = v -> {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        };
        this.runAndCheck(publishImmediately, onPublish);
    }

    private void runAndCheck(Predicate<Integer> publishImmediately, Consumer<Integer> onPublish) throws InterruptedException {
        CopyOnWriteArrayList result = new CopyOnWriteArrayList();
        BufferedPublisher pub = new BufferedPublisher("pub-1", 5L, publishImmediately, onPublish.andThen(result::add));
        pub.start();
        int total = 1001;
        ArrayList<Integer> required = new ArrayList<Integer>();
        for (int i = 0; i < total; ++i) {
            pub.buffer((Object)i);
            Thread.sleep(1L);
            if (!publishImmediately.test(i)) continue;
            required.add(i);
        }
        pub.close();
        ((ListAssert)((ListAssert)((ListAssert)Assertions.assertThat(result).containsAll(required)).hasSizeGreaterThan(required.size())).hasSizeLessThan(total)).hasSameSizeAs(new HashSet(result));
        Assertions.assertThat((boolean)Ordering.natural().isOrdered(result)).isTrue();
    }
}

