/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db.mapper;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import io.debezium.connector.spanner.db.dao.ChangeStreamResultSetMetadata;
import io.debezium.connector.spanner.db.mapper.ChangeStreamRecordMapper;
import io.debezium.connector.spanner.db.mapper.MapperUtils;
import io.debezium.connector.spanner.db.model.ChildPartition;
import io.debezium.connector.spanner.db.model.Mod;
import io.debezium.connector.spanner.db.model.Partition;
import io.debezium.connector.spanner.db.model.StreamEventMetadata;
import io.debezium.connector.spanner.db.model.event.ChildPartitionsEvent;
import io.debezium.connector.spanner.db.model.event.DataChangeEvent;
import io.debezium.connector.spanner.db.model.event.HeartbeatEvent;
import io.debezium.connector.spanner.db.model.schema.Column;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.joda.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class ChangeStreamRecordMapperTest {
    ChangeStreamRecordMapperTest() {
    }

    @Test
    void testToChangeStreamEvents() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        HashSet parentTokens = new HashSet();
        Timestamp startTimestamp = Timestamp.ofTimeMicroseconds((long)1L);
        Partition partition = new Partition("token", parentTokens, startTimestamp, Timestamp.ofTimeMicroseconds((long)1L));
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.getStructList(Mockito.anyInt())).thenReturn(new ArrayList());
        Assertions.assertTrue((boolean)changeStreamRecordMapper.toChangeStreamEvents(partition, struct, (ChangeStreamResultSetMetadata)Mockito.mock(ChangeStreamResultSetMetadata.class)).isEmpty());
        ((Struct)Mockito.verify((Object)struct)).getStructList(Mockito.anyInt());
    }

    @Test
    void testToChangeStreamEvents2() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        HashSet parentTokens = new HashSet();
        Timestamp startTimestamp = Timestamp.ofTimeMicroseconds((long)1L);
        Partition partition = new Partition("token", parentTokens, startTimestamp, Timestamp.ofTimeMicroseconds((long)1L));
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.getStructList((String)Mockito.any())).thenReturn(new ArrayList());
        ArrayList<Struct> structList = new ArrayList<Struct>();
        structList.add(struct);
        Struct row = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)row.getStructList(Mockito.anyInt())).thenReturn(structList);
        Assertions.assertTrue((boolean)changeStreamRecordMapper.toChangeStreamEvents(partition, row, (ChangeStreamResultSetMetadata)Mockito.mock(ChangeStreamResultSetMetadata.class)).isEmpty());
        ((Struct)Mockito.verify((Object)row)).getStructList(Mockito.anyInt());
        ((Struct)Mockito.verify((Object)struct, (VerificationMode)Mockito.atLeast((int)1))).getStructList((String)Mockito.any());
    }

    @Test
    void testToChangeStreamEvents3() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        HashSet parentTokens = new HashSet();
        Timestamp startTimestamp = Timestamp.ofTimeMicroseconds((long)1L);
        Partition partition = new Partition("token", parentTokens, startTimestamp, Timestamp.ofTimeMicroseconds((long)1L));
        Struct struct1 = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct1.getStructList((String)Mockito.any())).thenReturn(new ArrayList());
        Struct struct2 = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct2.getStructList((String)Mockito.any())).thenReturn(new ArrayList());
        ArrayList<Struct> structList = new ArrayList<Struct>();
        structList.add(struct1);
        structList.add(struct2);
        Struct row = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)row.getStructList(Mockito.anyInt())).thenReturn(structList);
        Assertions.assertTrue((boolean)changeStreamRecordMapper.toChangeStreamEvents(partition, row, (ChangeStreamResultSetMetadata)Mockito.mock(ChangeStreamResultSetMetadata.class)).isEmpty());
        ((Struct)Mockito.verify((Object)row)).getStructList(Mockito.anyInt());
        ((Struct)Mockito.verify((Object)struct1, (VerificationMode)Mockito.atLeast((int)1))).getStructList((String)Mockito.any());
        ((Struct)Mockito.verify((Object)struct2, (VerificationMode)Mockito.atLeast((int)1))).getStructList((String)Mockito.any());
    }

    @Test
    void testToChangeStreamEvents4() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        HashSet parentTokens = new HashSet();
        Timestamp startTimestamp = Timestamp.ofTimeMicroseconds((long)1L);
        Partition partition = new Partition("token", parentTokens, startTimestamp, Timestamp.ofTimeMicroseconds((long)1L));
        Struct struct1 = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct1.getStructList((String)Mockito.any())).thenReturn(new ArrayList());
        Struct struct2 = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct2.getStructList((String)Mockito.any())).thenThrow(new Throwable[]{new IllegalArgumentException()});
        Struct struct3 = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct3.getStructList((String)Mockito.any())).thenReturn(new ArrayList());
        ArrayList<Struct> structList = new ArrayList<Struct>();
        structList.add(struct1);
        structList.add(struct2);
        structList.add(struct3);
        Struct row = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)row.getStructList(Mockito.anyInt())).thenReturn(structList);
        Assertions.assertThrows(IllegalArgumentException.class, () -> changeStreamRecordMapper.toChangeStreamEvents(partition, row, (ChangeStreamResultSetMetadata)Mockito.mock(ChangeStreamResultSetMetadata.class)));
        ((Struct)Mockito.verify((Object)row)).getStructList(Mockito.anyInt());
        ((Struct)Mockito.verify((Object)struct2)).getStructList((String)Mockito.any());
    }

    @Test
    void testToChangeStreamEvents5() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        HashSet parentTokens = new HashSet();
        Timestamp startTimestamp = Timestamp.ofTimeMicroseconds((long)1L);
        Partition partition = new Partition("String", parentTokens, startTimestamp, Timestamp.ofTimeMicroseconds((long)1L));
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.getStructList(Mockito.anyInt())).thenReturn(new ArrayList());
        Assertions.assertTrue((boolean)changeStreamRecordMapper.toChangeStreamEvents(partition, struct, (ChangeStreamResultSetMetadata)Mockito.mock(ChangeStreamResultSetMetadata.class)).isEmpty());
        ((Struct)Mockito.verify((Object)struct)).getStructList(Mockito.anyInt());
    }

    @Test
    void testToChangeStreamEvents6() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        HashSet parentTokens = new HashSet();
        Timestamp startTimestamp = Timestamp.ofTimeMicroseconds((long)1L);
        Partition partition = new Partition("String", parentTokens, startTimestamp, Timestamp.ofTimeMicroseconds((long)1L));
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.getStructList((String)Mockito.any())).thenReturn(new ArrayList());
        ArrayList<Struct> structList = new ArrayList<Struct>();
        structList.add(struct);
        Struct struct1 = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct1.getStructList(Mockito.anyInt())).thenReturn(structList);
        Assertions.assertTrue((boolean)changeStreamRecordMapper.toChangeStreamEvents(partition, struct1, (ChangeStreamResultSetMetadata)Mockito.mock(ChangeStreamResultSetMetadata.class)).isEmpty());
        ((Struct)Mockito.verify((Object)struct1)).getStructList(Mockito.anyInt());
        ((Struct)Mockito.verify((Object)struct, (VerificationMode)Mockito.atLeast((int)1))).getStructList((String)Mockito.any());
    }

    @Test
    void testToChangeStreamEvents7() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        HashSet parentTokens = new HashSet();
        Timestamp startTimestamp = Timestamp.ofTimeMicroseconds((long)1L);
        Partition partition = new Partition("String", parentTokens, startTimestamp, Timestamp.ofTimeMicroseconds((long)1L));
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.getStructList((String)Mockito.any())).thenReturn(new ArrayList());
        Struct struct1 = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct1.getStructList((String)Mockito.any())).thenReturn(new ArrayList());
        ArrayList<Struct> structList = new ArrayList<Struct>();
        structList.add(struct1);
        structList.add(struct);
        Struct struct2 = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct2.getStructList(Mockito.anyInt())).thenReturn(structList);
        Assertions.assertTrue((boolean)changeStreamRecordMapper.toChangeStreamEvents(partition, struct2, (ChangeStreamResultSetMetadata)Mockito.mock(ChangeStreamResultSetMetadata.class)).isEmpty());
        ((Struct)Mockito.verify((Object)struct2)).getStructList(Mockito.anyInt());
        ((Struct)Mockito.verify((Object)struct1, (VerificationMode)Mockito.atLeast((int)1))).getStructList((String)Mockito.any());
        ((Struct)Mockito.verify((Object)struct, (VerificationMode)Mockito.atLeast((int)1))).getStructList((String)Mockito.any());
    }

    @Test
    void testToChangeStreamEvents8() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        HashSet parentTokens = new HashSet();
        Timestamp startTimestamp = Timestamp.ofTimeMicroseconds((long)1L);
        Partition partition = new Partition("String", parentTokens, startTimestamp, Timestamp.ofTimeMicroseconds((long)1L));
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.getStructList((String)Mockito.any())).thenReturn(new ArrayList());
        Struct struct1 = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct1.getStructList((String)Mockito.any())).thenReturn(new ArrayList());
        Struct struct2 = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct2.getStructList((String)Mockito.any())).thenThrow(new Throwable[]{new IllegalArgumentException()});
        ArrayList<Struct> structList = new ArrayList<Struct>();
        structList.add(struct2);
        structList.add(struct1);
        structList.add(struct);
        Struct struct3 = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct3.getStructList(Mockito.anyInt())).thenReturn(structList);
        Assertions.assertThrows(IllegalArgumentException.class, () -> changeStreamRecordMapper.toChangeStreamEvents(partition, struct3, (ChangeStreamResultSetMetadata)Mockito.mock(ChangeStreamResultSetMetadata.class)));
        ((Struct)Mockito.verify((Object)struct3)).getStructList(Mockito.anyInt());
        ((Struct)Mockito.verify((Object)struct2)).getStructList((String)Mockito.any());
    }

    @Test
    void testToStreamEvent() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        HashSet parentTokens = new HashSet();
        Timestamp startTimestamp = Timestamp.ofTimeMicroseconds((long)1L);
        Partition partition = new Partition("String", parentTokens, startTimestamp, Timestamp.ofTimeMicroseconds((long)1L));
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.getStructList((String)Mockito.any())).thenReturn(new ArrayList());
        changeStreamRecordMapper.toStreamEvent(partition, struct, (ChangeStreamResultSetMetadata)Mockito.mock(ChangeStreamResultSetMetadata.class));
        ((Struct)Mockito.verify((Object)struct, (VerificationMode)Mockito.atLeast((int)1))).getStructList((String)Mockito.any());
    }

    @Test
    void testToStreamEventThrows() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        HashSet parentTokens = new HashSet();
        Timestamp startTimestamp = Timestamp.ofTimeMicroseconds((long)1L);
        Partition partition = new Partition("String", parentTokens, startTimestamp, Timestamp.ofTimeMicroseconds((long)1L));
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.getStructList((String)Mockito.any())).thenThrow(new Throwable[]{new IllegalArgumentException()});
        Assertions.assertThrows(IllegalArgumentException.class, () -> changeStreamRecordMapper.toStreamEvent(partition, struct, (ChangeStreamResultSetMetadata)Mockito.mock(ChangeStreamResultSetMetadata.class)));
        ((Struct)Mockito.verify((Object)struct)).getStructList((String)Mockito.any());
    }

    @Test
    void testIsNonNullDataChangeRecordNullDataChangeRecord() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.isNull((String)Mockito.any())).thenReturn((Object)true);
        Assertions.assertFalse((boolean)changeStreamRecordMapper.isNonNullDataChangeRecord(struct));
        ((Struct)Mockito.verify((Object)struct)).isNull((String)Mockito.any());
    }

    @Test
    void testIsNonNullDataChangeRecordNonNullDataChangeRecord() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.isNull((String)Mockito.any())).thenReturn((Object)false);
        Assertions.assertTrue((boolean)changeStreamRecordMapper.isNonNullDataChangeRecord(struct));
        ((Struct)Mockito.verify((Object)struct)).isNull((String)Mockito.any());
    }

    @Test
    void testIsNonNullDataChangeRecordThrows() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.isNull((String)Mockito.any())).thenThrow(new Throwable[]{new IllegalArgumentException()});
        Assertions.assertThrows(IllegalArgumentException.class, () -> changeStreamRecordMapper.isNonNullDataChangeRecord(struct));
        ((Struct)Mockito.verify((Object)struct)).isNull((String)Mockito.any());
    }

    @Test
    void testIsNonNullHeartbeatRecordNullHeartbeatRecord() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.isNull((String)Mockito.any())).thenReturn((Object)true);
        Assertions.assertFalse((boolean)changeStreamRecordMapper.isNonNullHeartbeatRecord(struct));
        ((Struct)Mockito.verify((Object)struct)).isNull((String)Mockito.any());
    }

    @Test
    void testIsNonNullHeartbeatRecordNonNullHeartbeatRecord() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.isNull((String)Mockito.any())).thenReturn((Object)false);
        Assertions.assertTrue((boolean)changeStreamRecordMapper.isNonNullHeartbeatRecord(struct));
        ((Struct)Mockito.verify((Object)struct)).isNull((String)Mockito.any());
    }

    @Test
    void testIsNonNullHeartbeatRecordThrows() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.isNull((String)Mockito.any())).thenThrow(new Throwable[]{new IllegalArgumentException()});
        Assertions.assertThrows(IllegalArgumentException.class, () -> changeStreamRecordMapper.isNonNullHeartbeatRecord(struct));
        ((Struct)Mockito.verify((Object)struct)).isNull((String)Mockito.any());
    }

    @Test
    void testIsNonNullChildPartitionsRecordNullChildPartitionsRecord() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.isNull((String)Mockito.any())).thenReturn((Object)true);
        Assertions.assertFalse((boolean)changeStreamRecordMapper.isNonNullChildPartitionsRecord(struct));
        ((Struct)Mockito.verify((Object)struct)).isNull((String)Mockito.any());
    }

    @Test
    void testIsNonNullChildPartitionsRecordNonNullChildPartitionsRecord() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.isNull((String)Mockito.any())).thenReturn((Object)false);
        Assertions.assertTrue((boolean)changeStreamRecordMapper.isNonNullChildPartitionsRecord(struct));
        ((Struct)Mockito.verify((Object)struct)).isNull((String)Mockito.any());
    }

    @Test
    void testIsNonNullChildPartitionsRecordThrows() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.isNull((String)Mockito.any())).thenThrow(new Throwable[]{new IllegalArgumentException()});
        Assertions.assertThrows(IllegalArgumentException.class, () -> changeStreamRecordMapper.isNonNullChildPartitionsRecord(struct));
        ((Struct)Mockito.verify((Object)struct)).isNull((String)Mockito.any());
    }

    @Test
    void testToDataChangeEvent() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        HashSet parentTokens = new HashSet();
        Timestamp startTimestamp = Timestamp.ofTimeMicroseconds((long)1L);
        Partition partition = new Partition("String", parentTokens, startTimestamp, Timestamp.ofTimeMicroseconds((long)1L));
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.getBoolean((String)Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)struct.getTimestamp((String)Mockito.any())).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)struct.getString((String)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)struct.getString("mod_type")).thenReturn((Object)"INSERT");
        Mockito.when((Object)struct.getString("value_capture_type")).thenReturn((Object)"NEW_ROW");
        Mockito.when((Object)struct.getStructList((String)Mockito.any())).thenReturn(new ArrayList());
        ChangeStreamResultSetMetadata metadata = (ChangeStreamResultSetMetadata)Mockito.mock(ChangeStreamResultSetMetadata.class);
        Mockito.when((Object)metadata.getTotalStreamDuration()).thenReturn((Object)Duration.millis((long)1L));
        DataChangeEvent dataChangeEvent = changeStreamRecordMapper.toDataChangeEvent(partition, struct, metadata);
        Assertions.assertEquals((Object)"String", (Object)dataChangeEvent.getServerTransactionId());
        Assertions.assertEquals((Object)startTimestamp, (Object)dataChangeEvent.getCommitTimestamp());
    }

    @Test
    void testToDataChangeEventThrows() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        HashSet parentTokens = new HashSet();
        Timestamp startTimestamp = Timestamp.ofTimeMicroseconds((long)1L);
        Partition partition = new Partition("String", parentTokens, startTimestamp, Timestamp.ofTimeMicroseconds((long)1L));
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.getColumnType((String)Mockito.any())).thenReturn((Object)Type.bool());
        ArrayList<Struct> structList = new ArrayList<Struct>();
        structList.add(struct);
        Struct struct1 = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct1.getBoolean((String)Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)struct1.getTimestamp((String)Mockito.any())).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)struct1.getString((String)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)struct1.getStructList((String)Mockito.any())).thenReturn(structList);
        Assertions.assertThrows(IllegalArgumentException.class, () -> changeStreamRecordMapper.toDataChangeEvent(partition, struct1, (ChangeStreamResultSetMetadata)Mockito.mock(ChangeStreamResultSetMetadata.class)));
        ((Struct)Mockito.verify((Object)struct1)).getBoolean((String)Mockito.any());
        ((Struct)Mockito.verify((Object)struct1)).getTimestamp((String)Mockito.any());
        ((Struct)Mockito.verify((Object)struct1, (VerificationMode)Mockito.atLeast((int)1))).getString((String)Mockito.any());
        ((Struct)Mockito.verify((Object)struct1)).getStructList((String)Mockito.any());
        ((Struct)Mockito.verify((Object)struct, (VerificationMode)Mockito.atLeast((int)1))).getColumnType((String)Mockito.any());
    }

    @Test
    void testToHeartbeatEvent() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        HashSet parentTokens = new HashSet();
        Timestamp ofTimeMicrosecondsResult = Timestamp.ofTimeMicroseconds((long)1L);
        Partition partition = new Partition("String", parentTokens, ofTimeMicrosecondsResult, Timestamp.ofTimeMicroseconds((long)1L));
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.getTimestamp((String)Mockito.any())).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        ChangeStreamResultSetMetadata changeStreamResultSetMetadata = (ChangeStreamResultSetMetadata)Mockito.mock(ChangeStreamResultSetMetadata.class);
        Mockito.when((Object)changeStreamResultSetMetadata.getNumberOfRecordsRead()).thenReturn((Object)1L);
        Timestamp ofTimeMicrosecondsResult1 = Timestamp.ofTimeMicroseconds((long)1L);
        Mockito.when((Object)changeStreamResultSetMetadata.getQueryStartedAt()).thenReturn((Object)ofTimeMicrosecondsResult1);
        Mockito.when((Object)changeStreamResultSetMetadata.getRecordReadAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)changeStreamResultSetMetadata.getRecordStreamEndedAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)changeStreamResultSetMetadata.getRecordStreamStartedAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)changeStreamResultSetMetadata.getTotalStreamDuration()).thenReturn((Object)Duration.millis((long)1L));
        HeartbeatEvent actualToHeartbeatEventResult = changeStreamRecordMapper.toHeartbeatEvent(partition, struct, changeStreamResultSetMetadata);
        Timestamp timestamp = actualToHeartbeatEventResult.getTimestamp();
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult, (Object)timestamp);
        StreamEventMetadata metadata = actualToHeartbeatEventResult.getMetadata();
        Assertions.assertSame((Object)timestamp, (Object)metadata.getRecordTimestamp());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult, (Object)metadata.getRecordStreamStartedAt());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult, (Object)metadata.getRecordStreamEndedAt());
        Assertions.assertEquals((long)1L, (long)metadata.getTotalStreamTimeMillis());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult, (Object)metadata.getPartitionEndTimestamp());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult, (Object)metadata.getRecordReadAt());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult1, (Object)metadata.getPartitionStartTimestamp());
        Assertions.assertEquals((long)1L, (long)metadata.getNumberOfRecordsRead());
        Assertions.assertEquals((Object)"String", (Object)metadata.getPartitionToken());
        Assertions.assertEquals((Object)timestamp, (Object)metadata.getQueryStartedAt());
        ((Struct)Mockito.verify((Object)struct)).getTimestamp((String)Mockito.any());
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getQueryStartedAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getRecordReadAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getRecordStreamEndedAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getRecordStreamStartedAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getNumberOfRecordsRead();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getTotalStreamDuration();
    }

    @Test
    void testToHeartbeatEvent2() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        HashSet parentTokens = new HashSet();
        Timestamp startTimestamp = Timestamp.ofTimeMicroseconds((long)1L);
        Partition partition = new Partition("String", parentTokens, startTimestamp, Timestamp.ofTimeMicroseconds((long)1L));
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.getTimestamp((String)Mockito.any())).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        ChangeStreamResultSetMetadata changeStreamResultSetMetadata = (ChangeStreamResultSetMetadata)Mockito.mock(ChangeStreamResultSetMetadata.class);
        Mockito.when((Object)changeStreamResultSetMetadata.getNumberOfRecordsRead()).thenThrow(new Throwable[]{new IllegalArgumentException()});
        Mockito.when((Object)changeStreamResultSetMetadata.getQueryStartedAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)changeStreamResultSetMetadata.getRecordReadAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)changeStreamResultSetMetadata.getRecordStreamEndedAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)changeStreamResultSetMetadata.getRecordStreamStartedAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)changeStreamResultSetMetadata.getTotalStreamDuration()).thenReturn((Object)Duration.millis((long)1L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> changeStreamRecordMapper.toHeartbeatEvent(partition, struct, changeStreamResultSetMetadata));
        ((Struct)Mockito.verify((Object)struct)).getTimestamp((String)Mockito.any());
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getQueryStartedAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getRecordReadAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getRecordStreamEndedAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getRecordStreamStartedAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getNumberOfRecordsRead();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getTotalStreamDuration();
    }

    @Test
    void testToChildPartitionsEvent() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        HashSet parentTokens = new HashSet();
        Timestamp ofTimeMicrosecondsResult = Timestamp.ofTimeMicroseconds((long)1L);
        Partition partition = new Partition("String", parentTokens, ofTimeMicrosecondsResult, Timestamp.ofTimeMicroseconds((long)1L));
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.getTimestamp((String)Mockito.any())).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)struct.getString((String)Mockito.any())).thenReturn((Object)"String");
        ArrayList structList = new ArrayList();
        Mockito.when((Object)struct.getStructList((String)Mockito.any())).thenReturn(structList);
        ChangeStreamResultSetMetadata changeStreamResultSetMetadata = (ChangeStreamResultSetMetadata)Mockito.mock(ChangeStreamResultSetMetadata.class);
        Mockito.when((Object)changeStreamResultSetMetadata.getNumberOfRecordsRead()).thenReturn((Object)1L);
        Mockito.when((Object)changeStreamResultSetMetadata.getQueryStartedAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)changeStreamResultSetMetadata.getRecordReadAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)changeStreamResultSetMetadata.getRecordStreamEndedAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)changeStreamResultSetMetadata.getRecordStreamStartedAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)changeStreamResultSetMetadata.getTotalStreamDuration()).thenReturn((Object)Duration.millis((long)1L));
        ChildPartitionsEvent actualToChildPartitionsEventResult = changeStreamRecordMapper.toChildPartitionsEvent(partition, struct, changeStreamResultSetMetadata);
        Assertions.assertEquals(structList, (Object)actualToChildPartitionsEventResult.getChildPartitions());
        Timestamp startTimestamp = actualToChildPartitionsEventResult.getStartTimestamp();
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult, (Object)startTimestamp);
        Assertions.assertEquals((Object)"String", (Object)actualToChildPartitionsEventResult.getRecordSequence());
        StreamEventMetadata metadata = actualToChildPartitionsEventResult.getMetadata();
        Assertions.assertEquals((long)1L, (long)metadata.getTotalStreamTimeMillis());
        Assertions.assertSame((Object)startTimestamp, (Object)metadata.getRecordTimestamp());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult, (Object)metadata.getRecordStreamStartedAt());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult, (Object)metadata.getRecordStreamEndedAt());
        Assertions.assertEquals((Object)"String", (Object)metadata.getPartitionToken());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult, (Object)metadata.getQueryStartedAt());
        Assertions.assertEquals((long)1L, (long)metadata.getNumberOfRecordsRead());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult, (Object)metadata.getRecordReadAt());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult, (Object)metadata.getPartitionEndTimestamp());
        Assertions.assertEquals((Object)startTimestamp, (Object)metadata.getPartitionStartTimestamp());
        ((Struct)Mockito.verify((Object)struct)).getTimestamp((String)Mockito.any());
        ((Struct)Mockito.verify((Object)struct)).getString((String)Mockito.any());
        ((Struct)Mockito.verify((Object)struct)).getStructList((String)Mockito.any());
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getQueryStartedAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getRecordReadAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getRecordStreamEndedAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getRecordStreamStartedAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getNumberOfRecordsRead();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getTotalStreamDuration();
    }

    @Test
    void testToChildPartitionsEventThrows() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        HashSet parentTokens = new HashSet();
        Timestamp startTimestamp = Timestamp.ofTimeMicroseconds((long)1L);
        Partition partition = new Partition("String", parentTokens, startTimestamp, Timestamp.ofTimeMicroseconds((long)1L));
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.getTimestamp((String)Mockito.any())).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)struct.getString((String)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)struct.getStructList((String)Mockito.any())).thenReturn(new ArrayList());
        ChangeStreamResultSetMetadata changeStreamResultSetMetadata = (ChangeStreamResultSetMetadata)Mockito.mock(ChangeStreamResultSetMetadata.class);
        Mockito.when((Object)changeStreamResultSetMetadata.getNumberOfRecordsRead()).thenThrow(new Throwable[]{new IllegalArgumentException()});
        Mockito.when((Object)changeStreamResultSetMetadata.getQueryStartedAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)changeStreamResultSetMetadata.getRecordReadAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)changeStreamResultSetMetadata.getRecordStreamEndedAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)changeStreamResultSetMetadata.getRecordStreamStartedAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)changeStreamResultSetMetadata.getTotalStreamDuration()).thenReturn((Object)Duration.millis((long)1L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> changeStreamRecordMapper.toChildPartitionsEvent(partition, struct, changeStreamResultSetMetadata));
        ((Struct)Mockito.verify((Object)struct)).getTimestamp((String)Mockito.any());
        ((Struct)Mockito.verify((Object)struct)).getString((String)Mockito.any());
        ((Struct)Mockito.verify((Object)struct)).getStructList((String)Mockito.any());
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getQueryStartedAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getRecordReadAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getRecordStreamEndedAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getRecordStreamStartedAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getNumberOfRecordsRead();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getTotalStreamDuration();
    }

    @Test
    void testToChildPartitionsEvent4() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        HashSet parentTokens = new HashSet();
        Timestamp ofTimeMicrosecondsResult = Timestamp.ofTimeMicroseconds((long)1L);
        Partition partition = new Partition("String", parentTokens, ofTimeMicrosecondsResult, Timestamp.ofTimeMicroseconds((long)1L));
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.getString((String)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)struct.getStringList((String)Mockito.any())).thenReturn(new ArrayList());
        ArrayList<Struct> structList = new ArrayList<Struct>();
        structList.add(struct);
        Struct struct1 = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct1.getTimestamp((String)Mockito.any())).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)struct1.getString((String)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)struct1.getStructList((String)Mockito.any())).thenReturn(structList);
        ChangeStreamResultSetMetadata changeStreamResultSetMetadata = (ChangeStreamResultSetMetadata)Mockito.mock(ChangeStreamResultSetMetadata.class);
        Mockito.when((Object)changeStreamResultSetMetadata.getNumberOfRecordsRead()).thenReturn((Object)1L);
        Timestamp ofTimeMicrosecondsResult1 = Timestamp.ofTimeMicroseconds((long)1L);
        Mockito.when((Object)changeStreamResultSetMetadata.getQueryStartedAt()).thenReturn((Object)ofTimeMicrosecondsResult1);
        Timestamp ofTimeMicrosecondsResult2 = Timestamp.ofTimeMicroseconds((long)1L);
        Mockito.when((Object)changeStreamResultSetMetadata.getRecordReadAt()).thenReturn((Object)ofTimeMicrosecondsResult2);
        Mockito.when((Object)changeStreamResultSetMetadata.getRecordStreamEndedAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)changeStreamResultSetMetadata.getRecordStreamStartedAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)changeStreamResultSetMetadata.getTotalStreamDuration()).thenReturn((Object)Duration.millis((long)1L));
        ChildPartitionsEvent actualToChildPartitionsEventResult = changeStreamRecordMapper.toChildPartitionsEvent(partition, struct1, changeStreamResultSetMetadata);
        List childPartitions = actualToChildPartitionsEventResult.getChildPartitions();
        Assertions.assertEquals((int)1, (int)childPartitions.size());
        Timestamp startTimestamp = actualToChildPartitionsEventResult.getStartTimestamp();
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult, (Object)startTimestamp);
        Assertions.assertEquals((Object)"String", (Object)actualToChildPartitionsEventResult.getRecordSequence());
        StreamEventMetadata metadata = actualToChildPartitionsEventResult.getMetadata();
        Assertions.assertSame((Object)startTimestamp, (Object)metadata.getRecordTimestamp());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult, (Object)metadata.getRecordStreamStartedAt());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult, (Object)metadata.getRecordStreamEndedAt());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult, (Object)metadata.getPartitionEndTimestamp());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult1, (Object)metadata.getPartitionStartTimestamp());
        Assertions.assertEquals((Object)"String", (Object)metadata.getPartitionToken());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult2, (Object)metadata.getQueryStartedAt());
        Assertions.assertEquals((long)1L, (long)metadata.getTotalStreamTimeMillis());
        Assertions.assertEquals((Object)startTimestamp, (Object)metadata.getRecordReadAt());
        Assertions.assertEquals((long)1L, (long)metadata.getNumberOfRecordsRead());
        ChildPartition getResult = (ChildPartition)childPartitions.get(0);
        Assertions.assertTrue((boolean)getResult.getParentTokens().isEmpty());
        Assertions.assertEquals((Object)"String", (Object)getResult.getToken());
        ((Struct)Mockito.verify((Object)struct1)).getTimestamp((String)Mockito.any());
        ((Struct)Mockito.verify((Object)struct1)).getString((String)Mockito.any());
        ((Struct)Mockito.verify((Object)struct1)).getStructList((String)Mockito.any());
        ((Struct)Mockito.verify((Object)struct)).getString((String)Mockito.any());
        ((Struct)Mockito.verify((Object)struct)).getStringList((String)Mockito.any());
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getQueryStartedAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getRecordReadAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getRecordStreamEndedAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getRecordStreamStartedAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getNumberOfRecordsRead();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getTotalStreamDuration();
    }

    @Test
    void testToChildPartitionsEvent5() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        HashSet parentTokens = new HashSet();
        Timestamp ofTimeMicrosecondsResult = Timestamp.ofTimeMicroseconds((long)1L);
        Partition partition = new Partition("Parent0", parentTokens, ofTimeMicrosecondsResult, Timestamp.ofTimeMicroseconds((long)1L));
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.getString((String)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)struct.getStringList((String)Mockito.any())).thenReturn(new ArrayList());
        ArrayList<Struct> structList = new ArrayList<Struct>();
        structList.add(struct);
        Struct struct1 = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct1.getTimestamp((String)Mockito.any())).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)struct1.getString((String)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)struct1.getStructList((String)Mockito.any())).thenReturn(structList);
        ChangeStreamResultSetMetadata changeStreamResultSetMetadata = (ChangeStreamResultSetMetadata)Mockito.mock(ChangeStreamResultSetMetadata.class);
        Mockito.when((Object)changeStreamResultSetMetadata.getNumberOfRecordsRead()).thenReturn((Object)1L);
        Timestamp ofTimeMicrosecondsResult1 = Timestamp.ofTimeMicroseconds((long)1L);
        Mockito.when((Object)changeStreamResultSetMetadata.getQueryStartedAt()).thenReturn((Object)ofTimeMicrosecondsResult1);
        Timestamp ofTimeMicrosecondsResult2 = Timestamp.ofTimeMicroseconds((long)1L);
        Mockito.when((Object)changeStreamResultSetMetadata.getRecordReadAt()).thenReturn((Object)ofTimeMicrosecondsResult2);
        Mockito.when((Object)changeStreamResultSetMetadata.getRecordStreamEndedAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)changeStreamResultSetMetadata.getRecordStreamStartedAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)changeStreamResultSetMetadata.getTotalStreamDuration()).thenReturn((Object)Duration.millis((long)1L));
        ChildPartitionsEvent actualToChildPartitionsEventResult = changeStreamRecordMapper.toChildPartitionsEvent(partition, struct1, changeStreamResultSetMetadata);
        List childPartitions = actualToChildPartitionsEventResult.getChildPartitions();
        Assertions.assertEquals((int)1, (int)childPartitions.size());
        Timestamp startTimestamp = actualToChildPartitionsEventResult.getStartTimestamp();
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult, (Object)startTimestamp);
        Assertions.assertEquals((Object)"String", (Object)actualToChildPartitionsEventResult.getRecordSequence());
        StreamEventMetadata metadata = actualToChildPartitionsEventResult.getMetadata();
        Assertions.assertSame((Object)startTimestamp, (Object)metadata.getRecordTimestamp());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult, (Object)metadata.getRecordStreamStartedAt());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult, (Object)metadata.getRecordStreamEndedAt());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult, (Object)metadata.getPartitionEndTimestamp());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult1, (Object)metadata.getPartitionStartTimestamp());
        Assertions.assertEquals((Object)"Parent0", (Object)metadata.getPartitionToken());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult2, (Object)metadata.getQueryStartedAt());
        Assertions.assertEquals((long)1L, (long)metadata.getTotalStreamTimeMillis());
        Assertions.assertEquals((Object)startTimestamp, (Object)metadata.getRecordReadAt());
        Assertions.assertEquals((long)1L, (long)metadata.getNumberOfRecordsRead());
        ChildPartition getResult = (ChildPartition)childPartitions.get(0);
        Assertions.assertEquals((int)1, (int)getResult.getParentTokens().size());
        Assertions.assertEquals((Object)"String", (Object)getResult.getToken());
        ((Struct)Mockito.verify((Object)struct1)).getTimestamp((String)Mockito.any());
        ((Struct)Mockito.verify((Object)struct1)).getString((String)Mockito.any());
        ((Struct)Mockito.verify((Object)struct1)).getStructList((String)Mockito.any());
        ((Struct)Mockito.verify((Object)struct)).getString((String)Mockito.any());
        ((Struct)Mockito.verify((Object)struct)).getStringList((String)Mockito.any());
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getQueryStartedAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getRecordReadAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getRecordStreamEndedAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getRecordStreamStartedAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getNumberOfRecordsRead();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getTotalStreamDuration();
    }

    @Test
    void testToChildPartitionsEvent7() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        HashSet parentTokens = new HashSet();
        Timestamp ofTimeMicrosecondsResult = Timestamp.ofTimeMicroseconds((long)1L);
        Partition partition = new Partition("String", parentTokens, ofTimeMicrosecondsResult, Timestamp.ofTimeMicroseconds((long)1L));
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.getString((String)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)struct.getStringList((String)Mockito.any())).thenReturn(new ArrayList());
        Struct struct1 = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct1.getString((String)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)struct1.getStringList((String)Mockito.any())).thenReturn(new ArrayList());
        ArrayList<Struct> structList = new ArrayList<Struct>();
        structList.add(struct1);
        structList.add(struct);
        Struct struct2 = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct2.getTimestamp((String)Mockito.any())).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)struct2.getString((String)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)struct2.getStructList((String)Mockito.any())).thenReturn(structList);
        ChangeStreamResultSetMetadata changeStreamResultSetMetadata = (ChangeStreamResultSetMetadata)Mockito.mock(ChangeStreamResultSetMetadata.class);
        Mockito.when((Object)changeStreamResultSetMetadata.getNumberOfRecordsRead()).thenReturn((Object)1L);
        Timestamp ofTimeMicrosecondsResult1 = Timestamp.ofTimeMicroseconds((long)1L);
        Mockito.when((Object)changeStreamResultSetMetadata.getQueryStartedAt()).thenReturn((Object)ofTimeMicrosecondsResult1);
        Timestamp ofTimeMicrosecondsResult2 = Timestamp.ofTimeMicroseconds((long)1L);
        Mockito.when((Object)changeStreamResultSetMetadata.getRecordReadAt()).thenReturn((Object)ofTimeMicrosecondsResult2);
        Mockito.when((Object)changeStreamResultSetMetadata.getRecordStreamEndedAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)changeStreamResultSetMetadata.getRecordStreamStartedAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)changeStreamResultSetMetadata.getTotalStreamDuration()).thenReturn((Object)Duration.millis((long)1L));
        ChildPartitionsEvent actualToChildPartitionsEventResult = changeStreamRecordMapper.toChildPartitionsEvent(partition, struct2, changeStreamResultSetMetadata);
        List childPartitions = actualToChildPartitionsEventResult.getChildPartitions();
        Assertions.assertEquals((int)2, (int)childPartitions.size());
        Timestamp startTimestamp = actualToChildPartitionsEventResult.getStartTimestamp();
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult, (Object)startTimestamp);
        Assertions.assertEquals((Object)"String", (Object)actualToChildPartitionsEventResult.getRecordSequence());
        StreamEventMetadata metadata = actualToChildPartitionsEventResult.getMetadata();
        Assertions.assertSame((Object)startTimestamp, (Object)metadata.getRecordTimestamp());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult, (Object)metadata.getRecordStreamStartedAt());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult, (Object)metadata.getRecordStreamEndedAt());
        Assertions.assertEquals((long)1L, (long)metadata.getNumberOfRecordsRead());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult, (Object)metadata.getPartitionEndTimestamp());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult1, (Object)metadata.getPartitionStartTimestamp());
        Assertions.assertEquals((Object)"String", (Object)metadata.getPartitionToken());
        Assertions.assertEquals((long)1L, (long)metadata.getTotalStreamTimeMillis());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult2, (Object)metadata.getQueryStartedAt());
        Assertions.assertEquals((Object)startTimestamp, (Object)metadata.getRecordReadAt());
        ChildPartition getResult = (ChildPartition)childPartitions.get(1);
        Set parentTokens1 = getResult.getParentTokens();
        Assertions.assertTrue((boolean)parentTokens1.isEmpty());
        Assertions.assertEquals((Object)"String", (Object)getResult.getToken());
        ChildPartition getResult1 = (ChildPartition)childPartitions.get(0);
        Assertions.assertEquals((Object)parentTokens1, (Object)getResult1.getParentTokens());
        Assertions.assertEquals((Object)"String", (Object)getResult1.getToken());
        ((Struct)Mockito.verify((Object)struct2)).getTimestamp((String)Mockito.any());
        ((Struct)Mockito.verify((Object)struct2)).getString((String)Mockito.any());
        ((Struct)Mockito.verify((Object)struct2)).getStructList((String)Mockito.any());
        ((Struct)Mockito.verify((Object)struct1)).getString((String)Mockito.any());
        ((Struct)Mockito.verify((Object)struct1)).getStringList((String)Mockito.any());
        ((Struct)Mockito.verify((Object)struct)).getString((String)Mockito.any());
        ((Struct)Mockito.verify((Object)struct)).getStringList((String)Mockito.any());
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getQueryStartedAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getRecordReadAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getRecordStreamEndedAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getRecordStreamStartedAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getNumberOfRecordsRead();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getTotalStreamDuration();
    }

    @Test
    void testColumnTypeFrom() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.getColumnType((String)Mockito.any())).thenReturn((Object)Type.string());
        Mockito.when((Object)struct.getString((String)Mockito.any())).thenReturn((Object)"{\"code\":\"STRING\"}");
        Column column = changeStreamRecordMapper.columnTypeFrom(struct);
        Assertions.assertEquals((Object)"{\"code\":\"STRING\"}", (Object)column.getName());
        ((Struct)Mockito.verify((Object)struct, (VerificationMode)Mockito.atLeast((int)1))).getColumnType((String)Mockito.any());
    }

    @Test
    void testColumnTypeFromThrowsBool() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.getColumnType((String)Mockito.any())).thenReturn((Object)Type.bool());
        Assertions.assertThrows(IllegalArgumentException.class, () -> changeStreamRecordMapper.columnTypeFrom(struct));
        ((Struct)Mockito.verify((Object)struct, (VerificationMode)Mockito.atLeast((int)1))).getColumnType((String)Mockito.any());
    }

    @Test
    void testColumnTypeFromThrows() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.getColumnType((String)Mockito.any())).thenThrow(new Throwable[]{new IllegalArgumentException()});
        Assertions.assertThrows(IllegalArgumentException.class, () -> changeStreamRecordMapper.columnTypeFrom(struct));
        ((Struct)Mockito.verify((Object)struct)).getColumnType((String)Mockito.any());
    }

    @Test
    void testModFrom() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.getColumnType((String)Mockito.any())).thenReturn((Object)Type.bool());
        Assertions.assertThrows(IllegalArgumentException.class, () -> changeStreamRecordMapper.modFrom(0, struct));
        ((Struct)Mockito.verify((Object)struct, (VerificationMode)Mockito.atLeast((int)1))).getColumnType((String)Mockito.any());
    }

    @Test
    void testModFromString() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.getColumnType((String)Mockito.any())).thenReturn((Object)Type.string());
        String jsonString = "{\"code\":\"STRING\"}";
        Mockito.when((Object)struct.getString((String)Mockito.any())).thenReturn((Object)jsonString);
        JsonNode jsonNode = MapperUtils.getJsonNode((String)jsonString);
        Mod expected = new Mod(0, jsonNode, jsonNode, jsonNode);
        Mod mod = changeStreamRecordMapper.modFrom(0, struct);
        Assertions.assertEquals((Object)expected.keysJsonNode(), (Object)mod.keysJsonNode());
        Assertions.assertEquals((Object)expected.oldValuesJsonNode(), (Object)mod.oldValuesJsonNode());
        Assertions.assertEquals((Object)expected.newValuesJsonNode(), (Object)mod.newValuesJsonNode());
        ((Struct)Mockito.verify((Object)struct, (VerificationMode)Mockito.atLeast((int)1))).getColumnType((String)Mockito.any());
    }

    @Test
    void testEmptyChildPartitionFrom() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.getString((String)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)struct.getStringList((String)Mockito.any())).thenReturn(new ArrayList());
        ChildPartition actualChildPartitionFromResult = changeStreamRecordMapper.childPartitionFrom("String", struct);
        Assertions.assertTrue((boolean)actualChildPartitionFromResult.getParentTokens().isEmpty());
        Assertions.assertEquals((Object)"String", (Object)actualChildPartitionFromResult.getToken());
        ((Struct)Mockito.verify((Object)struct)).getString((String)Mockito.any());
        ((Struct)Mockito.verify((Object)struct)).getStringList((String)Mockito.any());
    }

    @Test
    void testChildPartitionFrom() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.getString((String)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)struct.getStringList((String)Mockito.any())).thenReturn(new ArrayList());
        ChildPartition actualChildPartitionFromResult = changeStreamRecordMapper.childPartitionFrom("Parent0", struct);
        Assertions.assertEquals((int)1, (int)actualChildPartitionFromResult.getParentTokens().size());
        Assertions.assertEquals((Object)"String", (Object)actualChildPartitionFromResult.getToken());
        ((Struct)Mockito.verify((Object)struct)).getString((String)Mockito.any());
        ((Struct)Mockito.verify((Object)struct)).getStringList((String)Mockito.any());
    }

    @Test
    void testChildPartitionFromThrows() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.getString((String)Mockito.any())).thenThrow(new Throwable[]{new IllegalArgumentException()});
        Mockito.when((Object)struct.getStringList((String)Mockito.any())).thenThrow(new Throwable[]{new IllegalArgumentException()});
        Assertions.assertThrows(IllegalArgumentException.class, () -> changeStreamRecordMapper.childPartitionFrom("Parent0", struct));
        ((Struct)Mockito.verify((Object)struct)).getStringList((String)Mockito.any());
    }

    @Test
    void testStreamEventMetadataFrom() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        HashSet parentTokens = new HashSet();
        Timestamp ofTimeMicrosecondsResult = Timestamp.ofTimeMicroseconds((long)1L);
        Partition partition = new Partition("String", parentTokens, ofTimeMicrosecondsResult, Timestamp.ofTimeMicroseconds((long)1L));
        Timestamp recordTimestamp = Timestamp.ofTimeMicroseconds((long)1L);
        ChangeStreamResultSetMetadata changeStreamResultSetMetadata = (ChangeStreamResultSetMetadata)Mockito.mock(ChangeStreamResultSetMetadata.class);
        Mockito.when((Object)changeStreamResultSetMetadata.getNumberOfRecordsRead()).thenReturn((Object)1L);
        Mockito.when((Object)changeStreamResultSetMetadata.getQueryStartedAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Timestamp ofTimeMicrosecondsResult1 = Timestamp.ofTimeMicroseconds((long)1L);
        Mockito.when((Object)changeStreamResultSetMetadata.getRecordReadAt()).thenReturn((Object)ofTimeMicrosecondsResult1);
        Timestamp ofTimeMicrosecondsResult2 = Timestamp.ofTimeMicroseconds((long)1L);
        Mockito.when((Object)changeStreamResultSetMetadata.getRecordStreamEndedAt()).thenReturn((Object)ofTimeMicrosecondsResult2);
        Mockito.when((Object)changeStreamResultSetMetadata.getRecordStreamStartedAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)changeStreamResultSetMetadata.getTotalStreamDuration()).thenReturn((Object)Duration.millis((long)1L));
        StreamEventMetadata actualStreamEventMetadataFromResult = changeStreamRecordMapper.streamEventMetadataFrom(partition, recordTimestamp, changeStreamResultSetMetadata);
        Assertions.assertEquals((long)1L, (long)actualStreamEventMetadataFromResult.getNumberOfRecordsRead());
        Assertions.assertEquals((long)1L, (long)actualStreamEventMetadataFromResult.getTotalStreamTimeMillis());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult, (Object)actualStreamEventMetadataFromResult.getRecordTimestamp());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult, (Object)actualStreamEventMetadataFromResult.getRecordStreamStartedAt());
        Timestamp partitionEndTimestamp = actualStreamEventMetadataFromResult.getPartitionEndTimestamp();
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult, (Object)partitionEndTimestamp);
        Assertions.assertEquals((Object)"String", (Object)actualStreamEventMetadataFromResult.getPartitionToken());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult, (Object)actualStreamEventMetadataFromResult.getQueryStartedAt());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult1, (Object)actualStreamEventMetadataFromResult.getPartitionStartTimestamp());
        Assertions.assertEquals((Object)ofTimeMicrosecondsResult2, (Object)actualStreamEventMetadataFromResult.getRecordReadAt());
        Assertions.assertEquals((Object)partitionEndTimestamp, (Object)actualStreamEventMetadataFromResult.getRecordStreamEndedAt());
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getQueryStartedAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getRecordReadAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getRecordStreamEndedAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getRecordStreamStartedAt();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getNumberOfRecordsRead();
        ((ChangeStreamResultSetMetadata)Mockito.verify((Object)changeStreamResultSetMetadata)).getTotalStreamDuration();
    }

    @Test
    void testGetJsonStringThrows() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.getColumnType((String)Mockito.any())).thenReturn((Object)Type.bool());
        Assertions.assertThrows(IllegalArgumentException.class, () -> changeStreamRecordMapper.getJsonString(struct, "Column Name"));
        ((Struct)Mockito.verify((Object)struct, (VerificationMode)Mockito.atLeast((int)1))).getColumnType((String)Mockito.any());
    }

    @Test
    void testGetJsonString() {
        ChangeStreamRecordMapper changeStreamRecordMapper = new ChangeStreamRecordMapper();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)struct.getJson((String)Mockito.any())).thenReturn((Object)"Json");
        Mockito.when((Object)struct.getColumnType((String)Mockito.any())).thenReturn((Object)Type.json());
        Assertions.assertEquals((Object)"Json", (Object)changeStreamRecordMapper.getJsonString(struct, "Column Name"));
        ((Struct)Mockito.verify((Object)struct)).getColumnType((String)Mockito.any());
        ((Struct)Mockito.verify((Object)struct)).getJson((String)Mockito.any());
    }
}

