/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner;

import io.debezium.connector.spanner.FinishingPartitionManager;
import java.util.function.Consumer;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class FinishingPartitionManagerTest {
    FinishingPartitionManagerTest() {
    }

    @Test
    void commitRecord() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(consumer);
        finishingPartitionManager.registerPartition("testToken");
        finishingPartitionManager.newRecord("testToken", "recordUid1");
        finishingPartitionManager.onPartitionFinishEvent("testToken");
        finishingPartitionManager.commitRecord("testToken", "recordUid1");
        ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept("testToken");
    }

    @Test
    void onPartitionFinishEvent() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(consumer);
        finishingPartitionManager.registerPartition("testToken");
        finishingPartitionManager.newRecord("testToken", "recordUid1");
        finishingPartitionManager.commitRecord("testToken", "recordUid1");
        finishingPartitionManager.onPartitionFinishEvent("testToken");
        ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept("testToken");
    }

    @Test
    void forceFinish() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(consumer);
        finishingPartitionManager.registerPartition("testToken");
        finishingPartitionManager.newRecord("testToken", "recordUid1");
        finishingPartitionManager.forceFinish("testToken");
        ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept("testToken");
    }

    @Test
    void withoutRegistration() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(consumer);
        finishingPartitionManager.newRecord("testToken", "recordUid1");
        finishingPartitionManager.commitRecord("testToken", "recordUid1");
        ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)0))).accept("testToken");
        finishingPartitionManager.onPartitionFinishEvent("testToken");
        ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)0))).accept("testToken");
    }

    @Test
    void multipleCommitFinishEventFirst() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(consumer);
        finishingPartitionManager.registerPartition("testToken");
        finishingPartitionManager.newRecord("testToken", "recordUid1");
        finishingPartitionManager.newRecord("testToken", "recordUid2");
        finishingPartitionManager.newRecord("testToken", "recordUid3");
        finishingPartitionManager.commitRecord("testToken", "recordUid1");
        finishingPartitionManager.commitRecord("testToken", "recordUid2");
        finishingPartitionManager.onPartitionFinishEvent("testToken");
        ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)0))).accept("testToken");
        finishingPartitionManager.commitRecord("testToken", "recordUid3");
        ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept("testToken");
    }

    @Test
    void multipleCommitCommitFirst1() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(consumer);
        finishingPartitionManager.registerPartition("testToken");
        finishingPartitionManager.newRecord("testToken", "recordUid1");
        finishingPartitionManager.newRecord("testToken", "recordUid2");
        finishingPartitionManager.newRecord("testToken", "recordUid3");
        finishingPartitionManager.commitRecord("testToken", "recordUid1");
        finishingPartitionManager.commitRecord("testToken", "recordUid2");
        finishingPartitionManager.commitRecord("testToken", "recordUid3");
        ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)0))).accept("testToken");
        finishingPartitionManager.onPartitionFinishEvent("testToken");
        ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept("testToken");
    }

    @Test
    void multipleCommitCommitFirst2() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(consumer);
        finishingPartitionManager.registerPartition("testToken");
        finishingPartitionManager.newRecord("testToken", "recordUid1");
        finishingPartitionManager.newRecord("testToken", "recordUid2");
        finishingPartitionManager.commitRecord("testToken", "recordUid1");
        finishingPartitionManager.commitRecord("testToken", "recordUid2");
        finishingPartitionManager.newRecord("testToken", "recordUid3");
        finishingPartitionManager.commitRecord("testToken", "recordUid3");
        ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)0))).accept("testToken");
        finishingPartitionManager.onPartitionFinishEvent("testToken");
        ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept("testToken");
    }

    @Test
    void multipleCommitNoEvents() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(consumer);
        finishingPartitionManager.registerPartition("testToken");
        ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)0))).accept("testToken");
        finishingPartitionManager.onPartitionFinishEvent("testToken");
        ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept("testToken");
    }

    @Test
    void multipleCommitNoEventsWithWrongCommitCall() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(consumer);
        finishingPartitionManager.registerPartition("testToken");
        finishingPartitionManager.commitRecord("testToken", "recordUid3");
        ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)0))).accept("testToken");
        finishingPartitionManager.onPartitionFinishEvent("testToken");
        ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept("testToken");
    }

    @Test
    void multipleCommitNoEventsWithWrongCommitCallOnly() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        FinishingPartitionManager finishingPartitionManager = new FinishingPartitionManager(consumer);
        finishingPartitionManager.registerPartition("testToken");
        finishingPartitionManager.commitRecord("testToken", "recordUid3");
        ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)0))).accept("testToken");
    }
}

