/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task.operation;

import com.google.cloud.Timestamp;
import io.debezium.connector.spanner.kafka.internal.model.PartitionState;
import io.debezium.connector.spanner.kafka.internal.model.PartitionStateEnum;
import io.debezium.connector.spanner.kafka.internal.model.TaskState;
import io.debezium.connector.spanner.task.TaskSyncContext;
import io.debezium.connector.spanner.task.operation.Operation;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionStatusUpdateOperation
implements Operation {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionStatusUpdateOperation.class);
    private final String token;
    private final PartitionStateEnum partitionStateEnum;

    public PartitionStatusUpdateOperation(String token, PartitionStateEnum partitionStateEnum) {
        this.token = token;
        this.partitionStateEnum = partitionStateEnum;
    }

    @Override
    public boolean isRequiredPublishSyncEvent() {
        return true;
    }

    @Override
    public TaskSyncContext doOperation(TaskSyncContext taskSyncContext) {
        return this.setState(taskSyncContext);
    }

    private TaskSyncContext setState(TaskSyncContext taskSyncContext) {
        TaskState currentTaskState = taskSyncContext.getCurrentTaskState();
        List<PartitionState> partitionsList = currentTaskState.getPartitions().stream().map(partitionState -> {
            if (partitionState.getToken().equals(this.token)) {
                if (PartitionStateEnum.FINISHED.equals((Object)this.partitionStateEnum)) {
                    return partitionState.toBuilder().state(this.partitionStateEnum).finishedTimestamp(Timestamp.now()).build();
                }
                return partitionState.toBuilder().state(this.partitionStateEnum).build();
            }
            return partitionState;
        }).collect(Collectors.toList());
        LOGGER.debug("Task updated status for partition, taskUid: {}, partition: {}, status: {}", new Object[]{taskSyncContext.getTaskUid(), this.token, this.partitionStateEnum});
        return taskSyncContext.toBuilder().currentTaskState(currentTaskState.toBuilder().partitions(partitionsList).build()).build();
    }
}

