/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task.operation;

import com.google.cloud.Timestamp;
import io.debezium.connector.spanner.kafka.internal.model.PartitionState;
import io.debezium.connector.spanner.kafka.internal.model.PartitionStateEnum;
import io.debezium.connector.spanner.task.TaskSyncContext;
import io.debezium.connector.spanner.task.operation.Operation;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorEndDetectionOperation
implements Operation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectorEndDetectionOperation.class);
    private final Runnable finishingWorkHandler;
    private final Timestamp endTime;
    private boolean isRequiredPublishSyncEvent = false;

    public ConnectorEndDetectionOperation(Runnable finishingWorkHandler, Timestamp endTime) {
        this.finishingWorkHandler = finishingWorkHandler;
        this.endTime = endTime;
    }

    @Override
    public boolean isRequiredPublishSyncEvent() {
        return this.isRequiredPublishSyncEvent;
    }

    @Override
    public TaskSyncContext doOperation(TaskSyncContext taskSyncContext) {
        if (this.endTime == null || taskSyncContext.isFinished()) {
            return taskSyncContext;
        }
        Set<String> tokens = this.getAllActivePartitions(taskSyncContext);
        if (Timestamp.now().toSqlTimestamp().after(this.endTime.toSqlTimestamp())) {
            if (tokens.isEmpty()) {
                this.finishingWorkHandler.run();
                LOGGER.info("Connector finished work, end time reached");
                this.isRequiredPublishSyncEvent = true;
                return taskSyncContext.toBuilder().finished(true).build();
            }
            LOGGER.warn("End time reached, but partitions are processing: {}", tokens);
        }
        return taskSyncContext;
    }

    private Set<String> getAllActivePartitions(TaskSyncContext taskSyncContext) {
        return taskSyncContext.getAllTaskStates().values().stream().flatMap(taskState -> Stream.concat(taskState.getPartitions().stream(), taskState.getSharedPartitions().stream())).filter(partitionState -> !partitionState.getState().equals((Object)PartitionStateEnum.FINISHED) && !partitionState.getState().equals((Object)PartitionStateEnum.REMOVED)).map(PartitionState::getToken).collect(Collectors.toSet());
    }
}

