/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task.operation;

import io.debezium.connector.spanner.db.stream.ChangeStream;
import io.debezium.connector.spanner.kafka.internal.model.PartitionState;
import io.debezium.connector.spanner.kafka.internal.model.PartitionStateEnum;
import io.debezium.connector.spanner.kafka.internal.model.TaskState;
import io.debezium.connector.spanner.task.TaskConflictResolver;
import io.debezium.connector.spanner.task.TaskSyncContext;
import io.debezium.connector.spanner.task.operation.Operation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckPartitionDuplicationOperation
implements Operation {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckPartitionDuplicationOperation.class);
    private boolean isRequiredPublishSyncEvent = false;
    private final ChangeStream changeStream;

    public CheckPartitionDuplicationOperation(ChangeStream changeStream) {
        this.changeStream = changeStream;
    }

    @Override
    public boolean isRequiredPublishSyncEvent() {
        return this.isRequiredPublishSyncEvent;
    }

    @Override
    public TaskSyncContext doOperation(TaskSyncContext taskSyncContext) {
        for (PartitionState partitionState : taskSyncContext.getCurrentTaskState().getPartitions()) {
            String token = partitionState.getToken();
            Map<String, PartitionState> taskUidPartitionState = this.getTasksStreamingPartition(taskSyncContext.getTaskStates().values(), token);
            if (taskUidPartitionState.isEmpty()) continue;
            this.isRequiredPublishSyncEvent = this.needToStopStreaming(taskSyncContext.getTaskUid(), taskUidPartitionState);
            if (this.isRequiredPublishSyncEvent) {
                taskSyncContext = this.stopStreaming(taskSyncContext, partitionState);
                LOGGER.debug("Stop streaming the partition: {}", (Object)token);
                continue;
            }
            LOGGER.warn("Continue streaming the partition: {}", (Object)token);
        }
        return taskSyncContext;
    }

    private Map<String, PartitionState> getTasksStreamingPartition(Collection<TaskState> taskStates, String token) {
        HashMap<String, PartitionState> result = new HashMap<String, PartitionState>();
        for (TaskState taskState : taskStates) {
            Optional<PartitionState> partitionState = taskState.getPartitions().stream().filter(state -> state.getToken().equals(token)).findFirst();
            partitionState.ifPresent(state -> result.put(taskState.getTaskUid(), (PartitionState)state));
        }
        return result;
    }

    private boolean needToStopStreaming(String currentTaskUid, Map<String, PartitionState> taskUidPartitionState) {
        Set<String> tasks = taskUidPartitionState.entrySet().stream().filter(entry -> PartitionStateEnum.RUNNING.equals((Object)((PartitionState)entry.getValue()).getState()) || PartitionStateEnum.SCHEDULED.equals((Object)((PartitionState)entry.getValue()).getState())).map(Map.Entry::getKey).collect(Collectors.toSet());
        return !TaskConflictResolver.hasPriority(currentTaskUid, tasks);
    }

    private TaskSyncContext stopStreaming(TaskSyncContext taskSyncContext, PartitionState state) {
        String token = state.getToken();
        this.changeStream.stop(token);
        TaskState currentTaskState = taskSyncContext.getCurrentTaskState();
        List<PartitionState> partitions = currentTaskState.getPartitions().stream().map(partitionState -> {
            if (partitionState.getToken().equals(token)) {
                return null;
            }
            return partitionState;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return taskSyncContext.toBuilder().currentTaskState(currentTaskState.toBuilder().partitions(partitions).build()).build();
    }
}

