/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.processor.heartbeat;

import com.google.common.annotations.VisibleForTesting;
import io.debezium.connector.spanner.SpannerPartition;
import io.debezium.function.BlockingConsumer;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.util.SchemaNameAdjuster;
import java.time.Instant;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpannerHeartbeat
implements Heartbeat {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpannerHeartbeat.class);
    private static final String PARTITION_TOKEN_KEY = "partitionToken";
    private final String topicName;
    private final Schema keySchema;
    private final Schema valueSchema;

    public SpannerHeartbeat(String topicName, SchemaNameAdjuster schemaNameAdjuster) {
        this.topicName = topicName;
        this.keySchema = SchemaBuilder.struct().name(schemaNameAdjuster.adjust("com.google.spanner.connector.PartitionTokenKey")).field(PARTITION_TOKEN_KEY, Schema.STRING_SCHEMA).build();
        this.valueSchema = SchemaBuilder.struct().name(schemaNameAdjuster.adjust("com.google.spanner.connector.Heartbeat")).field("ts_ms", Schema.INT64_SCHEMA).build();
    }

    public void heartbeat(Map<String, ?> partition, Map<String, ?> offset, BlockingConsumer<SourceRecord> consumer) throws InterruptedException {
        this.forcedBeat(partition, offset, consumer);
    }

    public void heartbeat(Map<String, ?> partition, Heartbeat.OffsetProducer offsetProducer, BlockingConsumer<SourceRecord> consumer) throws InterruptedException {
        this.forcedBeat(partition, offsetProducer.offset(), consumer);
    }

    public void forcedBeat(Map<String, ?> partition, Map<String, ?> offset, BlockingConsumer<SourceRecord> consumer) throws InterruptedException {
        LOGGER.debug("Generating heartbeat event");
        if (offset == null || offset.isEmpty()) {
            throw new IllegalStateException("Offset is not provided");
        }
        consumer.accept((Object)this.heartbeatRecord(partition, offset));
    }

    public boolean isEnabled() {
        return true;
    }

    @VisibleForTesting
    Struct partitionTokenKey(String partitionToken) {
        Struct result = new Struct(this.keySchema);
        result.put(PARTITION_TOKEN_KEY, (Object)partitionToken);
        return result;
    }

    @VisibleForTesting
    Struct messageValue() {
        Struct result = new Struct(this.valueSchema);
        result.put("ts_ms", (Object)Instant.now().toEpochMilli());
        return result;
    }

    @VisibleForTesting
    SourceRecord heartbeatRecord(Map<String, String> sourcePartition, Map<String, ?> sourceOffset) {
        String token = SpannerPartition.extractToken(sourcePartition);
        return new SourceRecord(sourcePartition, sourceOffset, this.topicName, Integer.valueOf(0), this.keySchema, (Object)this.partitionTokenKey(token), this.valueSchema, (Object)this.messageValue());
    }
}

