/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db.model;

import com.google.cloud.Timestamp;
import com.google.common.base.Preconditions;
import java.util.Set;

public class Partition {
    private final String partitionToken;
    private final Set<String> parentTokens;
    private final Timestamp startTimestamp;
    private final Timestamp endTimestamp;

    public Partition(String partitionToken, Set<String> parentTokens, Timestamp startTimestamp, Timestamp endTimestamp) {
        this.partitionToken = partitionToken;
        this.parentTokens = parentTokens;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getToken() {
        return this.partitionToken;
    }

    public Set<String> getParentTokens() {
        return this.parentTokens;
    }

    public Timestamp getStartTimestamp() {
        return this.startTimestamp;
    }

    public Timestamp getEndTimestamp() {
        return this.endTimestamp;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return "Partition{token='" + this.partitionToken + "', parentTokens=" + this.parentTokens + ", startTimestamp=" + this.startTimestamp + ", endTimestamp=" + this.endTimestamp + "}";
    }

    public static class Builder {
        private String partitionToken;
        private Set<String> parentTokens;
        private Timestamp startTimestamp;
        private Timestamp endTimestamp;

        public Builder() {
        }

        private Builder(Partition partition) {
            this.partitionToken = partition.partitionToken;
            this.startTimestamp = partition.startTimestamp;
            this.endTimestamp = partition.endTimestamp;
        }

        public Builder token(String partitionToken) {
            this.partitionToken = partitionToken;
            return this;
        }

        public Builder parentTokens(Set<String> parentTokens) {
            this.parentTokens = parentTokens;
            return this;
        }

        public Builder startTimestamp(Timestamp startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public Builder endTimestamp(Timestamp endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public Partition build() {
            Preconditions.checkState((this.partitionToken != null ? 1 : 0) != 0, (Object)"partitionToken");
            Preconditions.checkState((this.parentTokens != null ? 1 : 0) != 0, (Object)"parentTokens");
            Preconditions.checkState((this.startTimestamp != null ? 1 : 0) != 0, (Object)"startTimestamp");
            return new Partition(this.partitionToken, this.parentTokens, this.startTimestamp, this.endTimestamp);
        }
    }
}

