/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinishingPartitionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FinishingPartitionManager.class);
    private final Consumer<String> finishedPartitionConsumer;
    private final Map<String, String> lastEmittedRecord = new ConcurrentHashMap<String, String>();
    private final Map<String, Boolean> partitionPendingFinish = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, String> lastCommittedRecord = new ConcurrentHashMap<String, String>();

    public FinishingPartitionManager(Consumer<String> finishedPartitionConsumer) {
        this.finishedPartitionConsumer = finishedPartitionConsumer;
    }

    public void newRecord(String token, String recordUid) {
        this.lastEmittedRecord.put(token, recordUid);
    }

    public void registerPartition(String token) {
        this.partitionPendingFinish.put(token, false);
    }

    public void commitRecord(String token, String recordUid) {
        Boolean pendingFinishFlag = this.partitionPendingFinish.get(token);
        if (pendingFinishFlag == null) {
            LOGGER.warn("Partition has not been registered to finish or already finished {}", (Object)token);
            return;
        }
        if (!pendingFinishFlag.booleanValue()) {
            this.lastCommittedRecord.put(token, recordUid);
            return;
        }
        if (this.lastEmittedRecord.get(token) == null || this.lastEmittedRecord.get(token).equals(recordUid)) {
            this.forceFinish(token);
        }
    }

    public void onPartitionFinishEvent(String token) {
        Boolean pendingFinishFlag = this.partitionPendingFinish.get(token);
        if (pendingFinishFlag == null) {
            LOGGER.warn("Partition has not been registered to finish or already finished {}", (Object)token);
            return;
        }
        if (this.lastEmittedRecord.get(token) == null || this.lastEmittedRecord.get(token).equals(this.lastCommittedRecord.get(token))) {
            this.forceFinish(token);
        } else {
            this.partitionPendingFinish.put(token, true);
        }
    }

    public void forceFinish(String token) {
        this.finishedPartitionConsumer.accept(token);
        this.partitionPendingFinish.remove(token);
        this.lastEmittedRecord.remove(token);
        this.lastCommittedRecord.remove(token);
    }

    public Set<String> getPendingFinishPartitions() {
        return this.partitionPendingFinish.entrySet().stream().filter(entry -> Boolean.TRUE.equals(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }
}

