/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task;

import io.debezium.connector.spanner.metrics.MetricsEventPublisher;
import io.debezium.connector.spanner.metrics.event.TaskStateChangeQueueUpdateMetricEvent;
import io.debezium.connector.spanner.task.LoggerUtils;
import io.debezium.connector.spanner.task.TaskStateChangeEventHandler;
import io.debezium.connector.spanner.task.TaskSyncContextHolder;
import io.debezium.connector.spanner.task.state.TaskStateChangeEvent;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskStateChangeEventProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskStateChangeEventProcessor.class);
    private final BlockingQueue<TaskStateChangeEvent> queue;
    private final TaskSyncContextHolder taskSyncContextHolder;
    private final TaskStateChangeEventHandler taskStateChangeEventHandler;
    private final Consumer<Throwable> errorHandler;
    private final MetricsEventPublisher metricsEventPublisher;
    private volatile Thread thread;

    public TaskStateChangeEventProcessor(int queueCapacity, TaskSyncContextHolder taskSyncContextHolder, TaskStateChangeEventHandler taskStateChangeEventHandler, Consumer<Throwable> errorHandler, MetricsEventPublisher metricsEventPublisher) {
        this.queue = new ArrayBlockingQueue<TaskStateChangeEvent>(queueCapacity);
        this.taskSyncContextHolder = taskSyncContextHolder;
        this.errorHandler = errorHandler;
        this.taskStateChangeEventHandler = taskStateChangeEventHandler;
        this.metricsEventPublisher = metricsEventPublisher;
    }

    private Thread createEventHandlerThread() {
        Thread thread = new Thread(() -> {
            while (!Thread.interrupted()) {
                TaskStateChangeEvent event;
                try {
                    LOGGER.debug("createEventHandlerThread: Wait for sync event");
                    event = this.queue.take();
                    this.metricsEventPublisher.publishMetricEvent(new TaskStateChangeQueueUpdateMetricEvent(this.queue.remainingCapacity()));
                    LoggerUtils.debug(LOGGER, "createEventHandlerThread: Received sync event of type: {}, event: {}", event.getClass().getSimpleName(), event);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                this.taskSyncContextHolder.awaitNewEpoch();
                this.taskSyncContextHolder.lock();
                try {
                    this.taskStateChangeEventHandler.processEvent(event);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    this.taskSyncContextHolder.unlock();
                }
            }
        }, "SpannerConnector-TaskStateChangeEventProcessor");
        thread.setUncaughtExceptionHandler((t, e) -> this.errorHandler.accept(e));
        return thread;
    }

    public void startProcessing() {
        if (this.thread != null) {
            return;
        }
        this.thread = this.createEventHandlerThread();
        this.thread.start();
    }

    public void stopProcessing() {
        if (this.thread != null) {
            this.queue.clear();
            this.thread.interrupt();
            this.thread = null;
        }
    }

    public void processEvent(TaskStateChangeEvent event) {
        this.queue.add(event);
        this.metricsEventPublisher.publishMetricEvent(new TaskStateChangeQueueUpdateMetricEvent(this.queue.remainingCapacity()));
    }
}

