/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task;

import io.debezium.connector.spanner.PartitionManager;
import io.debezium.connector.spanner.db.model.Partition;
import io.debezium.connector.spanner.kafka.internal.model.PartitionStateEnum;
import io.debezium.connector.spanner.task.state.NewPartitionsEvent;
import io.debezium.connector.spanner.task.state.PartitionStatusUpdateEvent;
import io.debezium.connector.spanner.task.state.TaskStateChangeEvent;
import java.util.List;
import java.util.function.Consumer;

public class SynchronizedPartitionManager
implements PartitionManager {
    private final Consumer<TaskStateChangeEvent> syncEventPublisher;

    public SynchronizedPartitionManager(Consumer<TaskStateChangeEvent> syncEventPublisher) {
        this.syncEventPublisher = syncEventPublisher;
    }

    @Override
    public void newChildPartitions(List<Partition> partitions) {
        this.syncEventPublisher.accept(new NewPartitionsEvent(partitions));
    }

    @Override
    public void updateToFinished(String token) {
        this.syncEventPublisher.accept(new PartitionStatusUpdateEvent(token, PartitionStateEnum.FINISHED));
    }

    @Override
    public void updateToRunning(String token) {
        this.syncEventPublisher.accept(new PartitionStatusUpdateEvent(token, PartitionStateEnum.RUNNING));
    }

    @Override
    public void updateToReadyForStreaming(String token) {
        this.syncEventPublisher.accept(new PartitionStatusUpdateEvent(token, PartitionStateEnum.READY_FOR_STREAMING));
    }
}

