/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.kafka.internal.proto;

import com.google.cloud.Timestamp;
import io.debezium.connector.spanner.kafka.event.proto.SyncEventProtos;
import io.debezium.connector.spanner.kafka.internal.model.MessageTypeEnum;
import io.debezium.connector.spanner.kafka.internal.model.PartitionState;
import io.debezium.connector.spanner.kafka.internal.model.PartitionStateEnum;
import io.debezium.connector.spanner.kafka.internal.model.TaskState;
import io.debezium.connector.spanner.kafka.internal.model.TaskSyncEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SyncEventFromProtoMapper {
    private SyncEventFromProtoMapper() {
    }

    public static TaskSyncEvent mapFromProto(SyncEventProtos.SyncEvent protoEvent) {
        List<SyncEventProtos.TaskState> protoStates = protoEvent.getTaskStatesList();
        HashMap<String, TaskState> connectorStates = new HashMap<String, TaskState>(protoStates.size());
        for (int i = 0; i < protoEvent.getTaskStatesCount(); ++i) {
            SyncEventProtos.TaskState protoState = protoEvent.getTaskStates(i);
            TaskState taskState = new TaskState(protoState.getTaskUid(), protoState.getConsumerId(), protoState.getRebalanceGenerationId(), protoState.getStateTimestamp(), SyncEventFromProtoMapper.mapPartitionsArray(protoState), SyncEventFromProtoMapper.mapSharedPartitionsArray(protoState));
            connectorStates.put(taskState.getTaskUid(), taskState);
        }
        return new TaskSyncEvent(protoEvent.getTaskUid(), protoEvent.getConsumerId(), protoEvent.getMessageTimestamp(), MessageTypeEnum.valueOf(protoEvent.getMessageType().name()), protoEvent.getRebalanceGenerationId(), protoEvent.getEpochOffset(), connectorStates);
    }

    private static Map<String, PartitionState> mapPartitionsArray(SyncEventProtos.TaskState protoState) {
        HashMap<String, PartitionState> partitions = new HashMap<String, PartitionState>(protoState.getPartitionsCount());
        for (int i = 0; i < protoState.getPartitionsCount(); ++i) {
            SyncEventProtos.PartitionState protoPartition = protoState.getPartitions(i);
            PartitionState partition = SyncEventFromProtoMapper.mapPartition(protoPartition);
            partitions.put(partition.getToken(), partition);
        }
        return partitions;
    }

    private static Map<String, PartitionState> mapSharedPartitionsArray(SyncEventProtos.TaskState protoState) {
        HashMap<String, PartitionState> partitions = new HashMap<String, PartitionState>(protoState.getSharedPartitionsCount());
        for (int i = 0; i < protoState.getSharedPartitionsCount(); ++i) {
            SyncEventProtos.PartitionState protoPartition = protoState.getSharedPartitions(i);
            PartitionState partition = SyncEventFromProtoMapper.mapPartition(protoPartition);
            partitions.put(partition.getToken(), partition);
        }
        return partitions;
    }

    private static PartitionState mapPartition(SyncEventProtos.PartitionState partitionState) {
        return new PartitionState(partitionState.getToken(), Timestamp.parseTimestamp((String)partitionState.getStartTimestamp()), partitionState.getEndTimestamp() != null && !partitionState.getEndTimestamp().isEmpty() ? Timestamp.parseTimestamp((String)partitionState.getEndTimestamp()) : null, PartitionStateEnum.valueOf(partitionState.getState().name()), new HashSet<String>((Collection<String>)partitionState.getParentsList()), partitionState.getAssigneeTaskUid(), partitionState.getFinishedTimestamp() != null && !partitionState.getFinishedTimestamp().isEmpty() ? Timestamp.parseTimestamp((String)partitionState.getFinishedTimestamp()) : null);
    }
}

