/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.kafka.internal;

import io.debezium.connector.spanner.SpannerConnectorConfig;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;

public class KafkaRebalanceTopicAdminService {
    private final AdminClient adminClient;
    private final String rebalancingTopic;
    private final int maxTasks;

    public KafkaRebalanceTopicAdminService(AdminClient adminClient, SpannerConnectorConfig config) {
        this.adminClient = adminClient;
        this.rebalancingTopic = config.rebalancingTopic();
        this.maxTasks = config.getMaxTasks();
    }

    public void createAdjustRebalanceTopic() {
        try {
            if (!this.topicExists()) {
                this.createTopic();
                return;
            }
            if (this.partitionCount() < this.maxTasks) {
                this.increasePartitions();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            throw new KafkaException((Throwable)e);
        }
    }

    private boolean topicExists() throws ExecutionException, InterruptedException {
        Set topics = (Set)this.adminClient.listTopics().names().get();
        return topics.contains(this.rebalancingTopic);
    }

    private void createTopic() throws ExecutionException, InterruptedException {
        NewTopic newTopic = new NewTopic(this.rebalancingTopic, Optional.of(this.maxTasks), Optional.empty());
        CreateTopicsResult result = this.adminClient.createTopics(List.of(newTopic));
        result.topicId(this.rebalancingTopic).get();
    }

    private void increasePartitions() {
        this.adminClient.createPartitions(Map.of(this.rebalancingTopic, NewPartitions.increaseTo((int)this.maxTasks)));
    }

    private int partitionCount() throws ExecutionException, InterruptedException {
        DescribeTopicsResult result = this.adminClient.describeTopics(List.of(this.rebalancingTopic));
        KafkaFuture description = (KafkaFuture)result.topicNameValues().get(this.rebalancingTopic);
        return ((TopicDescription)description.get()).partitions().size();
    }
}

